package com.mini.framework.third.weixin.pay.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 微信公众号号支付配置
 * @author jayheo
 *
 */
public class WxPublicPayConfig  {
    /**
     * <pre>
     * 支付完成后的异步通知地址.
     * 这个地址会忽略参数，也就是?问号及他后面的参数。
     * 这些参数不会丢失，而体现在xml里面
     * </pre>
     */
    private String notifyUrl;

    /**
     * 支付完成后的同步返回地址.
     */
    private String returnUrl;
	
    /**
     * 公众号appId
     */
    private String appId;

    /**
     * 公众号appSecret
     */
    private String appSecret;

    /**
     * 商户号
     * 例如 1555371381
     */
    private String mchId;

    /**
     * 商户密钥
     * 密钥文件目前没有使用到。
     */
    private String mchKey;
    
    /**
     * 商户的证书文件
     */
    private byte[] mchCert;
    
    /**
     * 证书的密钥
     */
    private String certSecret;


	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

	public String getAppSecret() {
		return appSecret;
	}

	public void setAppSecret(String appSecret) {
		this.appSecret = appSecret;
	}

	public String getMchId() {
		return mchId;
	}

	public void setMchId(String mchId) {
		this.mchId = mchId;
	}

	public String getMchKey() {
		return mchKey;
	}

	public void setMchKey(String mchKey) {
		this.mchKey = mchKey;
	}

	public String getNotifyUrl() {
		return notifyUrl;
	}

	/**
     * 支付完成后的异步通知地址.
     * 这个地址会忽略参数，也就是?问号及他后面的参数。
     * 这些参数不会丢失，而体现在xml里面
	 * @param notifyUrl
	 */
	public void setNotifyUrl(String notifyUrl) {
		this.notifyUrl = notifyUrl;
	}

	public String getReturnUrl() {
		return returnUrl;
	}

	public void setReturnUrl(String returnUrl) {
		this.returnUrl = returnUrl;
	}

	public byte[] getMchCert() {
		return mchCert;
	}

	public void setMchCert(byte[] mchCert) {
		this.mchCert = mchCert;
	}
	
    public String getCertSecret() {
		return certSecret;
	}

	public void setCertSecret(String certSecret) {
		this.certSecret = certSecret;
	}

	@Override
    public String toString() {
		return ToStringBuilder.reflectionToString(this,ToStringStyle.SHORT_PREFIX_STYLE);
    }
    
}
