package com.mini.framework.third.weixin.server.client;

import java.util.Optional;
import java.util.function.Consumer;

import com.mini.framework.third.weixin.server.comm.TicketResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import com.mini.framework.third.weixin.server.comm.AccessTokenResponse;
import com.mini.framework.third.weixin.server.comm.DefaultMenuResonpse;
import com.mini.framework.third.weixin.server.comm.OpenidListResponse;
import com.mini.framework.third.weixin.server.comm.SceneQrcodeRequest;
import com.mini.framework.third.weixin.server.comm.SceneQrcodeResponse;
import com.mini.framework.third.weixin.server.comm.TemplateListResponse;
import com.mini.framework.third.weixin.server.model.ServerJsapiTicketResponse;
import com.mini.framework.third.weixin.server.model.WeixinBaseUserDetail;
import com.mini.framework.third.weixin.server.model.WeixinServerUserDetail;
import com.mini.framework.third.weixin.server.model.WeixinWebAuthTokenResp;


//@FeignClient(url="https://api.weixin.qq.com",name = "weixinServer",path="/cgi-bin")
/**
 * @author jayheo
 * 微信服务号sdk
 */
public interface WeixinServerAccountSdk {
	
	String serverAccountSdkPackage = "com.mini.framework.third.weixin.server"; 
	String redisServerTokenLock = "server:global:cache:site:weixin:server:token";
	
	/**<pre>
http请求方式: POST
URL: https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=TOKEN
POST数据格式：json
POST数据例子：{"expire_seconds": 604800, "action_name": "QR_SCENE", "action_info": {"scene": {"scene_id": 123}}}

或者也可以使用以下POST数据创建字符串形式的二维码参数：
{"expire_seconds": 604800, "action_name": "QR_STR_SCENE", "action_info": {"scene": {"scene_str": "test"}}}
</pre>
	 * */
	
	@PostMapping("/qrcode/create?access_token=11")
	public SceneQrcodeResponse createSceneQrcode(@RequestBody SceneQrcodeRequest req);
	
	/**
	 * 创建accesstoken
	 * @return
	 */
	@GetMapping("/token?grant_type=client_credential&appid=%s&secret=%s")
	public AccessTokenResponse createAccessToken();
	
	
	/**
	 * 查询关注的openid 列表
	 * https://api.weixin.qq.com/cgi-bin/user/get?access_token=15_cJyzavEYErGyNVGHppyQYN6ahoF7OXh3zXwDUqgYP7XvIQFRDKaltvNt_s9IIWyHnQt6HLJ8CI-JUH7oq1N5vVOH0-0YoCnV281z4DMt5diR6nxlKXLgL7k6ON5j33XjwQmHTMGnfMQjfbjfPFYeADAKAT&next_openid=o1JSn1NRMlBVFxLDSHwgiO4Sw7Ms
	 * @param offset 起点openid如果没有就传空
	 * @return
	 */
	@GetMapping("/user/get?access_token=%s&next_openid=%s")
	public OpenidListResponse querySubscribeOpenidList(String offset);
	
	
	/*
https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421140839
接口调用请求说明
http请求方式: GET
https://api.weixin.qq.com/cgi-bin/user/info?access_token=ACCESS_TOKEN&openid=OPENID&lang=zh_CN
	 * */
	/**
	 * 根据openid查用户信息。
	 * @param openid
	 * @return
	 */
	@GetMapping("/user/info?access_token=%s&openid=%s&lang=zh_CN")
	public WeixinServerUserDetail queryUserDetailByOpenid(String openid);
	
	
	/**
	 *  通过code查询用户信息
	 * @param code
	 * @return
	 */
	default public WeixinServerUserDetail queryAuthByCode(String code){
		return queryAuthByCode(code, c->{});
	}
	
	/**
	 * 通过code查询用户信息
	 * 这个方法会先查一个token，再通过token查询用户信息。
	 * 所以现在提供了使用中间变量的方式。
	 * @param code
	 * @param tokenRespConsumer   使用中间变量的方式。Consumer
	 * @return
	 */
	@GetMapping("/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code")
	public WeixinServerUserDetail queryAuthByCode(String code,Consumer<WeixinWebAuthTokenResp> tokenRespConsumer);
	
	
	/**
	 * 通过openid查询用户信息
	 * 这里要注意，一般不要用这个方法，这里用网页授权 登录的，
	 * 这个网页授权用户可能没有关注的。
	 * @param webAuthAccessToken 这个与服务号的accessToken并不是一个东西。
	 * @param openid
	 * @return
	 */
	@GetMapping("/sns/userinfo")
	public WeixinBaseUserDetail queryUserDetailByUserAccessToken(String webAuthAccessToken,String openid);

	//TODO 经常出现这个错误 调用微信出错status:45047,msg:out of response count limit hint: [ArTqza0889ge32]  因为超过了可以发信息的时间
	//TODO 发送文本消息
	
	//https://sh.api.weixin.qq.com/cgi-bin/message/custom/send?access_token=%s
	
	/**
	 * 发送客服信息
	 * @param openId
	 * @param content
	 */
	@PostMapping("/message/custom/send?access_token=%s")
	public void sendTextMsg(String openId, String content);
	
	
	@GetMapping("/ticket/getticket?access_token=%s&type=jsapi")
	default public String createJsapiTicket(){
		TicketResponse ticketResp = createJsapiTicketResponse();
		return ticketResp.getTicket();
	}

	@GetMapping("/ticket/getticket?access_token=%s&type=jsapi")
	public TicketResponse createJsapiTicketResponse();
	

	/**
	 * @param url 签名的使用当前地址栏的url，不是要跳转的url
	 * @param appid 这个appid必须与当前的access token的appid匹配。
	 * @return
	 */
	default public ServerJsapiTicketResponse createJsapiTicket(String url,String appid){
		String ticket = createJsapiTicket();
		ServerJsapiTicketResponse ticketResp = new ServerJsapiTicketResponse(url, ticket, appid);
		ticketResp.sign();
		return ticketResp;
	}
	
	
	//--------------------------------------模板消息功能区
//在使用模板消息的时候务必记录要开通模板消息的功能。https://mp.weixin.qq.com/advanced/tmplmsgapply?action=intro&t=tmplmsg/intro&token=2051978481&lang=zh_CN
	
	/* 这个接口的返值是这个样子的
	 * {
    "errcode": 0,
    "errmsg": "ok",
    "msgid": 515127404159926300
}
	 * */
	/**
	 * 发送模板消息 如成成功了会返回消息id，否则失败
	 *TODO 这里应该可以抛出一个异常，来记录模板id不存的情况。方便上面捕捉异常，并做合适的处理
	 * @param reqBody
	 * @return
	 */
	@PostMapping("/message/template/send?access_token=%s")
	public String sendTempateMsg( String reqBody );
	
	/**
	 *  创建一个微信的消息模板
	 * @param templateKey
	 * @return 
	 */
	@PostMapping("/template/api_add_template?access_token=%s")
	public String createMsgTempate(String templateKey);

	/**
	 * 查询存在模板列表
	 * @return 
	 */
	@GetMapping("/template/get_all_private_template?access_token=%s")
	public TemplateListResponse queryExistTemplateList();
	

	/**
	  删除某个模板id
	 * @return 
	 */
	@PostMapping("/template/del_private_template?access_token=%s")
	public void deleteTemplateResponse(String templateId);
	
	/**
	 * 查询微信模板消息的行业
	 * @return 
	 */
	@GetMapping("/template/get_industry?access_token=%s")
	public String queryTemplateIndustry();
	
	
	public Optional<String> currentRunnableServerAppid();
	
	
	//----------------------------------------------模板消息 功能区
	
	
	//----------------------------------------------自自定义菜单
	
	
	
	@GetMapping("/get_current_selfmenu_info?access_token=%s")
	public DefaultMenuResonpse getServerDefaultMenu(); 
	
	
	@PostMapping("/menu/create?access_token=%s")
	public void setServerDefaultMenu(String reqJson); 
	
	//自定义菜单的增删除改查。至少先弄个自由使用接口的地方
	//TODO https://developers.weixin.qq.com/doc/offiaccount/Custom_Menus/Creating_Custom-Defined_Menu.html
	
	
}
