package com.mini.framework.third.weixin.server.comm;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.third.weixin.util.ErrorHandlerResponse;
import com.mini.framework.util.string.GsonUtil;

public abstract class AbstractResponse implements ErrorHandlerResponse{
	@SerializedName("errcode")
	private int code = 0;
	@SerializedName("errmsg")
	private String msg;
	
	private String respOriginal;
	
	public int getCode() {
		return code;
	}
	public void setCode(int code) {
		this.code = code;
	}
	public String getMsg() {
		return msg;
	}
	public void setMsg(String msg) {
		this.msg = msg;
	}
	
	public String getRespOriginal() {
		return respOriginal;
	}
	public void setRespOriginal(String respOriginal) {
		this.respOriginal = respOriginal;
	}
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.DEFAULT_STYLE);
	}
	
	public static <T extends AbstractResponse> T fromJson(Class<T> clazz,String json){
		T resp = GsonUtil.buildMilliSecondDateGson().fromJson(json, clazz);
		resp.setRespOriginal(json);
		return resp;
	}
	
}
