package com.mini.framework.third.weixin.server.model;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.third.weixin.server.comm.AbstractResponse;

public class WeixinWebAuthTokenResp  extends AbstractResponse{

    @SerializedName("access_token")
    private String accessToken;
    @SerializedName("expires_in")
    private Integer expire;
    /**
     * 这个数据建议保存到数据库，方便后需要的时候去更新用户信息
     * 如果用户3月1号点击授权后，服务器3月20号因为已授权过了直接进来，
     * 这个时候我们保存refreshToken，那么4月10号，这个refreshToken还能用吗？
     * 如果能用，那么每个进入时都把refreshToken保存一个那么是不是一直可以查询用户的详情了。
     * */
    @SerializedName("refresh_token")
    private String refreshToken;
    @SerializedName("scope")
    private String scope;
    @SerializedName("openid")
    private String openId;
	public String getAccessToken() {
		return accessToken;
	}
	public void setAccessToken(String accessToken) {
		this.accessToken = accessToken;
	}
	public Integer getExpire() {
		return expire;
	}
	public void setExpire(Integer expire) {
		this.expire = expire;
	}
	public String getRefreshToken() {
		return refreshToken;
	}
	public void setRefreshToken(String refreshToken) {
		this.refreshToken = refreshToken;
	}
	public String getScope() {
		return scope;
	}
	public void setScope(String scope) {
		this.scope = scope;
	}
	public String getOpenId() {
		return openId;
	}
	public void setOpenId(String openId) {
		this.openId = openId;
	}
	
	/**
	 * 是不是有用户的信息
	 * @return
	 */
	public boolean haveUserInfoModel(){
		return "snsapi_userinfo".equalsIgnoreCase(scope);
	}
    
}
