package com.mini.framework.third.weixin.server.model.menu;

import java.lang.reflect.Type;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;

public class ButtonTypeDeserializer implements JsonDeserializer<WeixinServerButtonType>{


	@Override
	public WeixinServerButtonType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
			throws JsonParseException {
		if(json.getAsJsonPrimitive().isJsonNull()){
			return WeixinServerButtonType.fromWeixinKey(null).orElse(null);
		}else{
			return WeixinServerButtonType.fromWeixinKey(json.getAsJsonPrimitive().getAsString()).orElse(null);
		}
	}
}
