package com.mini.framework.third.weixin.server.model.menu;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.mini.framework.util.string.GsonUtil;

public class WeixinServerMenu {

	@SerializedName("button")
	private List<WeixinServerButton> buttons = new ArrayList<WeixinServerButton>();
	
	
	public List<WeixinServerButton> getButtons() {
		return buttons;
	}

	public void setButtons(List<WeixinServerButton> buttons) {
		this.buttons = buttons;
	}

	public WeixinServerMenu(){}
	
	public static WeixinServerMenu create(){
		return new WeixinServerMenu();
	}
	
	public WeixinServerMenu addButton(WeixinServerButton button){
		return addButtons(button);
	}

	public WeixinServerMenu addButtons(List<WeixinServerButton> buttons){
		this.buttons.addAll(buttons);
		return this;
	}
	public WeixinServerMenu addButtons(WeixinServerButton... buttons){
		return addButtons(Stream.of(buttons).collect(Collectors.toList()));
	}
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
	
	public static UnaryOperator<GsonBuilder> gsonBulderOperator(){
		Type type = new TypeToken<List<WeixinServerButton>>() {}.getType();
		return builder->builder
				.registerTypeAdapter(type, new JsonDeserializer<List<WeixinServerButton>>() {
					@Override
					public List<WeixinServerButton> deserialize(JsonElement json, Type typeOfT,
							JsonDeserializationContext context) throws JsonParseException {
						List<WeixinServerButton> beans = new ArrayList<>();
						if(json.isJsonObject()){
							json = json.getAsJsonObject().get("list");
						}
						if(json.isJsonArray()){
							JsonArray array = json.getAsJsonArray();
							array.iterator().forEachRemaining(bean->{
								beans.add(context.deserialize(bean, WeixinServerButton.class));
							});
						}
						return beans;
					}
				})
				.registerTypeAdapter(WeixinServerButtonType.class,new ButtonTypeSerializer())
				.registerTypeAdapter(WeixinServerButtonType.class,new ButtonTypeDeserializer());
	}
	
	public String toWeixinReqMessage(){
		return GsonUtil.createBaseBuilder(gsonBulderOperator()).create().toJson(this);
	}
	
}
