package com.mini.framework.third.weixin.server.model.template;

import java.util.List;
import java.util.Map;

import com.mini.framework.model.flag.EnumTypeShower;

/**
 * 行业的名字
 * @author jayheo
 *
 */
public enum IndustryNames implements EnumTypeShower<IndustryNames>{

	//TODO 谢志豪，换成name index，用于控制顺序
	
	class01("IT科技","互联网电子商务","IT软件与服务","IT硬件与设备","电子技术","通信与运营商","网络游戏"),
	class02("金融业","银行","证券基金理财信托","保险"),
	class03("餐饮","餐饮"),
	class04("酒店旅游","酒店","旅游"),
	class05("运输与仓储","快递","物流","仓储"),
	class06("教育","培训","院校"),
	class07("政府与公共事业","学术科研","交警","博物馆","政府公共事业非盈利机构"),
	class08("医疗护理","医药医疗","护理美容","保健与卫生"),
	class09("交通工具","汽车相关","摩托车相关","火车相关","飞机相关"),
	class10("房地产","房地产建筑","物业"),
	class11("消费品","消费品"),
	class12("商业服务","法律","广告会展","中介服务","检测认证","会计审计"),
	class13("文体娱乐","文化传媒","体育","娱乐休闲"),
	class14("印刷","打印印刷"),
	class15( "其他","其他"),
	
	;
	
	public static List<Map<String, Object>>showFieldMapsStatic(){
		return IndustryNames.class10.showFieldMaps();
	}
	
	private String title;
	
	private String[] subTitles;
	
	public String title() {
		return title;
	}

	public String[] subTitles() {
		return subTitles;
	}

	private IndustryNames(String title, String... subTitles) {
		this.title = title;
		this.subTitles = subTitles;
	}

	@Override
	public void fillFieldToMap(Map<String, Object> map) {
		map.put("title", title);
		map.put("subTitles", subTitles);
	}


	
}
