package com.mini.framework.third.weixin.server.model.template;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.mini.framework.core.exception.standard.CustomException;

public class TemplateContentItem {
	
	/**
	 * 是不是可变的
	 */
	private Boolean variable;

	/**
	 * 变量的名字
	 */
	private String varName;
	
	/**
	 * 当前记录的值
	 */
	private String value;
	
	/**
	 * 颜色
	 * #154DA3
	 */
	private String color;
	
	
	public TemplateContentItem() {
		super();
	}
	
	
	public static TemplateContentItem createStaticItem(String value){
		return new TemplateContentItem(false, null, value,null);
	}
	
	public static TemplateContentItem createVariableItem(String varName,String value){
		return createVariableItem(varName, value,"#000000");
	}
	public static TemplateContentItem createVariableItem(String varName,String value,String color){
		return new TemplateContentItem(true, varName, value,color);
	}

	public TemplateContentItem(Boolean variable, String varName, String value,String color) {
		super();
		this.variable = variable;
		this.varName = varName;
		this.value = value;
		this.color = color;
	}




	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public Boolean getVariable() {
		return variable;
	}

	public void setVariable(Boolean variable) {
		this.variable = variable;
	}

	public String getVarName() {
		return varName;
	}

	public void setVarName(String varName) {
		this.varName = varName;
	}
	
	public String getColor() {
		return color;
	}

	public void setColor(String color) {
		this.color = color;
	}


	/**
	 * 复制出一个副本
	 * @return
	 */
	public TemplateContentItem copy(){
		return new TemplateContentItem(variable, varName, value,color);
	}
	
	public String toValue(Map<String, Object> params){
		if(variable){
			return String.valueOf(params.get(varName));
		}else{
			return value;
		}
	}
	
	public boolean ifVariable(){
		return Optional.ofNullable(variable).orElse(false);
	}
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}


	public<E extends CustomException> void validateSameDocumentVersion(TemplateContentItem otherItem, Function<String,E>exceptionSupplier) {
		if(this.ifVariable()!=otherItem.ifVariable()){
			throw exceptionSupplier.apply("不能一个是变量一个不是变量");
		}
		
		if(this.ifVariable()){
			if( !Objects.equals(this.varName,otherItem.varName)){
				throw exceptionSupplier.apply(String.format("变量名必须一致:[%s]!=[%s]",this.varName, otherItem.varName));
			}
		}else{
			if(!Objects.equals(this.value,otherItem.value)){
				throw exceptionSupplier.apply(String.format("非变量的内容必须一致:[%s]!=[%s]",this.value, otherItem.value));
			}
		}
	}
}
