package com.mini.framework.third.weixin.server.util.tpmsg;

import java.util.List;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

/**
 * 模板参数
 * 
 * @author jayheo
 *
 */
public class TempKeyword {
	/**
	 * 参数key
	 */
	private String name;
	/**
	 * 参数值
	 */
	private String value;

	/**
	 * 颜色
	 */
	private String color;
	
	/**
	 * 标题
	 */
	private String title;

	public TempKeyword() {
		super();
	}
	

	public TempKeyword(String name, String value, String color) {
		super();
		this.name = name;
		this.value = value;
		this.color = color;
	}

	public String getColor() {
		return color;
	}

	public void setColor(String color) {
		this.color = color;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getTitle() {
		return title;
	}
	public void setTitle(String title) {
		this.title = title;
	}
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
	


	public static List<TempKeyword> fromJson(String json){
		return new Gson().fromJson(json, new TypeToken<List<TempKeyword>>(){}.getType());
	}
	
}
