package com.mini.framework.third.weixin.server.util.tpmsg;

import java.util.LinkedHashMap;
import java.util.Map;

import com.google.gson.Gson;


/**
 *https://developers.weixin.qq.com/miniprogram/dev/api-backend/open-api/template-message/templateMessage.send.html
 *  请求报文建造器
 * @author jayheo
 *
 */
public class WeixinJsonReqBuilder extends LinkedHashMap<String, Object>{

	/**
	 * 
	 */
	private static final long serialVersionUID = 851371762354258832L;

	private static final String  openidKey = "touser";
	
	private static final String  mappTokenKey = "form_id";
	
	private static final String  mappPathKey = "page";
	
	private static final String tempIdKey = "template_id";
	
	private static final String clickUrlKey= "url";
	
	private static final String bodyKey = "data";

	private static final String paramValueKey = "value";
	
	private static final String paramColorKey = "color";
	
	private static final String defaultColor = "#173177";
	
	private LinkedHashMap<String, Map<String, String>> body;
	
	public static WeixinJsonReqBuilder create(){
		WeixinJsonReqBuilder msg = new WeixinJsonReqBuilder();
		return msg.init();
	}
	
	private WeixinJsonReqBuilder init() {
		body = new LinkedHashMap<>();
		
		return body(body);
	}

	private WeixinJsonReqBuilder map(String key,Object val){
		put(key, val);
		return this;
	}
	
	/**
	 * 添加openid
	 * @param openid
	 * @return
	 */
	public WeixinJsonReqBuilder openid(String openid){
		return map(openidKey, openid);
	}
	
	/**
	 * 对应某个用户小程序发信息的授权
	 * @param token
	 * @return
	 */
	public WeixinJsonReqBuilder mappToken(String token){
		return map(mappTokenKey, token);
	}
	
	/**
	 * 小程序的路径，
	 * 这里决定了进小程序会进到哪里
	 * @param mappPath
	 * @return
	 */
	public WeixinJsonReqBuilder mappPathIfAbsent(String mappPath){
		putIfAbsent(mappPathKey, mappPath);
		return this;
	}
	
	
	/**
	 * 添加clickUrl
	 * @param clickUrl
	 * @return
	 */
	public WeixinJsonReqBuilder clickUrl(String clickUrl){
		return map(clickUrlKey, clickUrl);
	}
	
	
	/**
	 * 添加tempId
	 * @param tempId
	 * @return
	 */
	public WeixinJsonReqBuilder tempId(String tempId){
		return map(tempIdKey, tempId);
	}
	
	
	/**
	 * 添加body
	 * @param body
	 * @return
	 */
	private WeixinJsonReqBuilder body(Object body){
		return map(bodyKey, body);
	}
	
	/**
	 * 添加参数
	 * @param name
	 * @param param
	 * @param color 颜色
	 * @return
	 */
	public WeixinJsonReqBuilder param(String name,String param,String color){
		LinkedHashMap<String, String> entry = new LinkedHashMap<>(2);
		entry.put(paramColorKey, color);
		entry.put(paramValueKey, param);
		this.body.put(name, entry);
		return this;
	}
	
	public WeixinJsonReqBuilder param(String name,String param){
		return param(name, param, defaultColor);
	}
	
	/**
	 * 这个方法只允许调用一次
	 * @param values
	 * @return
	 */
	public WeixinJsonReqBuilder keyword(String... values){
		for (int i = 0; i < values.length; i++) {
			String value = values[i];
			param("keyword" + (i+1), value, defaultColor);
		}
		return this;
	}
	
	
	/**
	 * TODO 这里要进行下排序
	 */
	private void sort(){
		Object bodyObj = remove(bodyKey);
		put(bodyKey, bodyObj);
	}
	

	public String build(){
		sort();
		return new Gson().toJson(this);
	}
}
