package com.mini.framework.third.weixin.server.util.tpmsg;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

public class WeixinServerIndustryDto {

	/**
	 * 主或者次 true代表是主 false代表是副
	 */
	private Boolean primaryOrDeputy;

	/**
	 * 可用的一级行业
	 */
	private String firstIndustryName;

	/**
	 * 可用的二级行业
	 */
	private String secondIndustryName;


	public WeixinServerIndustryDto() {
		super();
	}

	public WeixinServerIndustryDto(Boolean primaryOrDeputy, String firstIndustryName, String secondIndustryName) {
		super();
		this.primaryOrDeputy = primaryOrDeputy;
		this.firstIndustryName = firstIndustryName;
		this.secondIndustryName = secondIndustryName;
	}

	public String getFirstIndustryName() {
		return firstIndustryName;
	}

	public void setFirstIndustryName(String firstIndustryName) {
		this.firstIndustryName = firstIndustryName;
	}

	public String getSecondIndustryName() {
		return secondIndustryName;
	}

	public void setSecondIndustryName(String secondIndustryName) {
		this.secondIndustryName = secondIndustryName;
	}

	public Boolean getPrimaryOrDeputy() {
		return primaryOrDeputy;
	}

	public void setPrimaryOrDeputy(Boolean primaryOrDeputy) {
		this.primaryOrDeputy = primaryOrDeputy;
	}
	
	public Comparator<WeixinServerIndustryDto> primaryOrDeputySorter(){
		Map<Boolean, Integer> primaryOrDeputySorter = new HashMap<>();
		primaryOrDeputySorter.put(true, 1);
		primaryOrDeputySorter.put(false, 2);
		return Comparator.comparing(industry->primaryOrDeputySorter.get(industry.getPrimaryOrDeputy()));
	}
	
	/**
	 * <pre>
	 * 是不是实际存在
	 * 如果没有两个行业，微信可能返回这个情况。
	 * 那么要有个方法过滤没有的。
	 * {"primary_industry":{"first_class":"IT科技","second_class":"互联网|电子商务"},"secondary_industry":{"first_class":"","second_class":""}}
	 * </pre>
	 * @return
	 */
	public boolean existence(){
		return !StringUtils.isBlank(firstIndustryName) &&  !StringUtils.isBlank(secondIndustryName);
	}
	
	public String industrysName(){
		return String.format("%s - %s",firstIndustryName,secondIndustryName);
	}

}
