package com.mini.framework.third.weixin.server.util.tpmsg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.string.RegexUtil;

public class WeixinTempDocFactory {
	
	/**
	 *
	 *最开始以为.* 可以匹配任意字符，后来发现有问题，匹配不了换行符\n
	 *查了下资料，用[\s\S]*匹配可以 
	 *解释：\s空白符，\S非空白符，所以[\s\S]是任意字符
	 * @return
	 */
	private static String getPattern(){
		String[] patternItems = {"编号",
		"(.*)",
		"标题",
		"(.*)",
		"行业",
		"(.*)",
		"使用人数",
		"(.*)",
		"最后修改时间",
		"(.*)",
		"详细内容",
		"([\\s\\S]+)"};
		
		return String.join("\n", patternItems);
	}
	
	private final static String pattern = getPattern(); 
	
	public static WeixinTempDoc tryParse(String docText){
		return parseFromText(docText).orElse(null);
	}
	
	
	public static Optional<WeixinTempDoc> parseFromText(String docText){
		String[] items = RegexUtil.getMatch(pattern, docText, 1,2,3,4,5,6);
		if(items==null){
			return Optional.empty();
		}
		WeixinTempDoc doc = new WeixinTempDoc();
		doc.setDocId(items[0]);
		doc.setTitle(items[1]);
		doc.setIndustry(items[2]);
		//TODO 设置时间
		doc.setExample(items[5]);
		parseKeywords(doc);
		return Optional.of(doc);
	}
	
	
	
	
	private final static String otherPattern = "[\\S\\s]*";
	
	private final static String keyPattern = "\\{\\{(.*)\\.DATA\\}\\}";

	private final static String  getWeixinRreplace(String key){
		
		return String.format("{{%s.DATA}}",key);
	} 
	

	private final static String  getRreplace(String key){
		
		return String.format("{{%s}}",key);
	} 
	
	@Deprecated//这个方法最好早点换了
	public static void parseKeywords(WeixinTempDoc doc){
		List<TempKeyword> keywords = new ArrayList<>();
		String exampleReplace = parseKeywords(doc.getExample(),keywords );
		doc.setExampleReplace(exampleReplace);
	}
	
	
	@Deprecated//这个方法最好早点换了
	public static List<TempKeyword>parseKeywords(String template){
		List<TempKeyword> keywords = new ArrayList<>();
		parseKeywords(template, keywords);
		return keywords;
	}
	
	
	@Deprecated//这个方法最好早点换了
	public static String parseKeywords(String template,List<TempKeyword>keywords){
		int length = template.split(keyPattern).length;
		String[] others = new String[length + 1];
		Arrays.fill(others, otherPattern);
		String pattern = String.join(keyPattern, others);
		Optional<List<String>> keysOptional = RegexUtil.getMatchItems(pattern, template);
		AssertUtil.assertNoBadReq(keysOptional.isPresent(), Status.BadReq.illParam, "匹配不到占位数据", template);
		List<String> keys = keysOptional.get();
		keys.forEach(key->{
			keywords.add(new TempKeyword(key, null, null));
		});
		String replace = template;
		for (String key : keys) {
			replace = replace.replace(getWeixinRreplace(key), getRreplace(key));
		}
		return replace;
	}
	
}
