package com.mini.framework.third.weixin.util;

import java.util.LinkedHashMap;
import java.util.Map;

import com.mini.framework.core.status.Status;
import com.mini.framework.core.status.StatusCode;
import com.mini.framework.util.asserts.AssertUtil;

public interface ErrorHandlerResponse {
	static Map<Integer, StatusCode> initErrorMap(){
		Map<Integer, StatusCode> errorMap = new LinkedHashMap<Integer, StatusCode>();
		//error:40102,msg:invalid industry id hint: [ujct03833888] 如果没有开通模板消息会这么提示
		errorMap.put(40102, Status.Busy.dataUnConfigSite);
		
		//error:47001,msg:data format error hint 消息格式错误
		errorMap.put(47001, Status.Third.wxClientFormatErr);
		
		//:error:40169,msg:invalid length for scene, or the data is not json string hint
		errorMap.put(40169, Status.Third.wxLimitHint);
		
		// :error:40163,msg:code been used, hints: [ req_id: kiodMfyFe-uGnCLa ]code:00108r6A1fm4Tc0Bht7A1exp6A108r62 (420000) 
		errorMap.put(40163, Status.BadReq.unsupportWeixinAuthCodeUsed);
		
		//error:40029,msg:invalid code, hints: [ req_id: qGBDWqLnRa-pUMvFa ]
		errorMap.put(40029, Status.BadReq.unsupportWeixinAuthCodeInvalid);
		
		//error:45026,msg:template num exceeds limit hint: [z4RRRa0492shb1]
		errorMap.put(45026, Status.Third.wxTemplateNumLimit);
		
		//error:48011,msg:disabled template id hint: [A04axa00791958]
		errorMap.put(48011, Status.Third.wxTemplateDisabled);
		//error:40037,msg:invalid template_id hint: [c.xMLa02543932]
		errorMap.put(40037, Status.Third.wxTemplateInvalid);
		
		//error:42001,msg:access_token expired hint: [WidZUa00681530!]
		errorMap.put(42001, Status.BadReq.expireWeixinAccessToken);



		// TODO 这里要弄一下错误码方便去处理formid失败的情况
		//ThirdException: error:41028,msg:invalid form id hint: [0U_T.a08253952] (420000)

		// TODO 在生成小程序码的时候如果线上小程序没有这个pages，那么就会报错这个错误41030。需要统一处理
		//error:41030,msg:invalid page hint: [JHCCoDALRa-nK6PwA]reqBody:{"scene":"ivt=68996888&pcard=7","page":"pages/command/awake/main","auto_color":false,"line_color":{"r":0,"b":0,"g":0},"is_hyaline":false} (420000)


		
		return errorMap;
	}

	static Map<Integer, StatusCode> errorMap = initErrorMap();
	
	
	default void handle(Map<Integer, StatusCode> errorMap, String message, Object... params) {
		StatusCode statusCode = errorMap.get(getCode());
		//TODO 记录没有映射的错误码
		statusCode = statusCode==null? Status.Third.weixin:statusCode;
		String thirdError = String.format("error:%s,msg:%s" , getCode(),getMsg());
		AssertUtil.simpleAssertByStatus(getCode() == 0, statusCode,thirdError + message ,params );
	}


	/**
	 * 使用这个方法可以在错误的时候加上一些日志
	 * @param message
	 * @param params
	 */
	default void handle(String errorMessage,Object...params) {
		String.format(errorMessage,new Object[params.length]);
		//TODO 这里务必过滤一下url中的secret=1d9f95d0efb08ff84cffc1f03efb40ca 以及  access_token=1894984984789489
		handle(errorMap,errorMessage,params);
	}

	int getCode();

	String getMsg();
	
	
	

}
