package com.mini.framework.third.weixin.wxpay.util;

import com.mini.framework.core.exception.HandleIOException;
import feign.RequestTemplate;
import feign.Response;
import org.apache.commons.io.IOUtils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

/**
 * @author jayheo
 */
public class FeignUtil {


    /**
     * 找到响应 body 内容
     * @param response 响应体。
     * @return
     */
    public static Optional<String> findResponseBody(Response response){
        return Optional.of(response).map(Response::body).map(FeignUtil::findResponseBody);
    }

    /**
     * 找到请求 body 内容
     * @param requestTemplate
     * @return
     */
    public static Optional<String> findRequestBody(RequestTemplate requestTemplate){
        return Optional.ofNullable(requestTemplate).map(RequestTemplate::body).map(String::new);
    }



    private static String findResponseBody(Response.Body body) {
        try {
            return String.join("", IOUtils.readLines(body.asInputStream(), "utf-8"));
        } catch (IOException e) {
            throw new HandleIOException(e, "从响应体读内容时出错");
        }
    }
}
