package com.mini.framework.third.weixin.wxpay.util.cache;

import java.util.Date;

/**
 * @author jayheo
 */
public class BeanExpireHolder<B> {

    private Date expireDate;

    private B bean;

    public BeanExpireHolder(long expireSeconds, B bean) {
        this.expireDate = new Date(System.currentTimeMillis() + expireSeconds * 1000);
        this.bean = bean;
    }

    public boolean ifNotNowExpire(){
        return !ifNowExpire();
    }
    public boolean ifNowExpire(){
        return expireDate == null || new Date().after(expireDate);
    }

    public Date getExpireDate() {
        return expireDate;
    }

    public void setExpireDate(Date expireDate) {
        this.expireDate = expireDate;
    }

    public B getBean() {
        return bean;
    }

    public void setBean(B bean) {
        this.bean = bean;
    }
}
