package com.mini.framework.third.weixin.wxpay.util.certificate;

import com.mini.framework.third.weixin.wxpay.v3.exception.WxpaySignatureConfigException;

/**
 * 证书签名时需要的参数。
 * @author jayheo
 */
public class CertificateSignatureRequireParams {

    /**
     * api请求的方法 GET POST
     */
    private String apiMethod;

    /**
     * api请求的路径不包含域名例如：
     * H5下单API 请求URL：https://api.mch.weixin.qq.com/v3/pay/transactions/h5
     * 这里 只需要 /v3/pay/transactions/h5 就可以了。
     * TODO 对于有问题的url还需要额外处理一下。
     */
    private String apiUrlPath;

    private String requestBody;
    
    public String sureHaveApiMethodForSignature() throws WxpaySignatureConfigException{
        if(apiMethod==null){
            throw new WxpaySignatureConfigException("签名时缺少参数:apiMethod");
        }
        return apiMethod;
    }
    
    public String sureHaveApiUrlPathForSignature() throws WxpaySignatureConfigException {
        
        if(apiUrlPath==null){
            throw new WxpaySignatureConfigException("签名时缺少参数:apiUrlPath");
        }
        return apiUrlPath;
    }
    
    
    public String sureHaveRequestBodyForSignature() throws WxpaySignatureConfigException {
        if (requestBody == null) {
            throw new WxpaySignatureConfigException("签名时缺少参数:requestBody");
        }
        return requestBody;
    }
    
    public String getApiMethod() {
        return apiMethod;
    }

    public void setApiMethod(String apiMethod) {
        this.apiMethod = apiMethod;
    }

    public String getApiUrlPath() {
        return apiUrlPath;
    }

    public void setApiUrlPath(String apiUrlPath) {
        this.apiUrlPath = apiUrlPath;
    }

    public String getRequestBody() {
        return requestBody;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }
}
