package com.mini.framework.third.weixin.wxpay.util.certificate;

import com.mini.framework.third.weixin.wxpay.v3.exception.WxpaySignatureConfigException;

/**
 * https://pay.weixin.qq.com/index.php/core/cert/api_cert#/api-cert-manage
 * 微信支付商户证书配置
 * @author jayheo
 */
public class WxpayMarketCertificateConfig {

    /**
     * 商户id/商户号
     * 例如:1519099751
     * https://pay.weixin.qq.com/index.php/extend/pay_setting
     */
    private String marketKey;

    /**
     * 证书序列号
     * https://pay.weixin.qq.com/index.php/core/cert/api_cert#/api-cert-manage
     * 例如:3DE3A99069B7A5D80825ADA40AFDFDCAF9B7C33D
     */
    private String serialNumber;

    /**
     * 证书内容文本
     * 它长什么样子。参考资源文件。
     * <pre>com.mini.framework.third.weixin.wxpay.util.certificate.wxpay_market_apiclient_key.pem</pre>
     */
    private String contentByteString;
    
    
    
    public String sureHaveMarketKeyForSignature()throws WxpaySignatureConfigException {
        if(marketKey==null){
            throw new WxpaySignatureConfigException("配置参数:marketKey 不能为空");
        }
        return marketKey;
    }
    
    
    
    public String sureHaveSerialNumberForSignature()throws WxpaySignatureConfigException {
        if(serialNumber==null){
            throw new WxpaySignatureConfigException("配置参数:serialNumber 不能为空");
        }
        return serialNumber;
    }
    
    
    
    public String sureHaveContentByteStringForSignature()throws WxpaySignatureConfigException {
        if(contentByteString==null){
            throw new WxpaySignatureConfigException("配置参数:contentByteString 不能为空");
        }
        return contentByteString;
    }
    
    
    

    public WxpayMarketCertificateConfig() {
    }

    public WxpayMarketCertificateConfig(String marketKey, String serialNumber, String contentByteString) {
        this.marketKey = marketKey;
        this.serialNumber = serialNumber;
        this.contentByteString = contentByteString;
    }

    public String getMarketKey() {
        return marketKey;
    }

    public void setMarketKey(String marketKey) {
        this.marketKey = marketKey;
    }

    public String getSerialNumber() {
        return serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getContentByteString() {
        return contentByteString;
    }

    public void setContentByteString(String contentByteString) {
        this.contentByteString = contentByteString;
    }
}
