package com.mini.framework.third.weixin.wxpay.util.decode;

import com.mini.framework.third.weixin.wxpay.util.FeignUtil;
import com.mini.framework.third.weixin.wxpay.v3.client.ResponseHeaderResolver;
import com.mini.framework.third.weixin.wxpay.v3.client.WxpayResponseMessageFounder;
import com.mini.framework.util.string.GsonUtil;
import feign.Response;
import feign.gson.GsonDecoder;
import org.apache.commons.io.IOUtils;

import java.io.IOException;
import java.lang.reflect.Type;

/**
 * 微信支付的gson形式的响应解析器
 * @author jayheo
 */
public class WxpayResponseGsonDecoder extends GsonDecoder {


    /**
     * 响应头部解析器
     */
    private final ResponseHeaderResolver headerResolver;


    /**
     * 要创建这个实例必须有响应头部的解析器
     * @param headerResolver
     */
    public WxpayResponseGsonDecoder(ResponseHeaderResolver headerResolver) {
        super(GsonUtil.buildMilliSecondDateGson());
        this.headerResolver = headerResolver;
    }

    @Override
    public Object decode(Response response, Type type) throws IOException {
        headerResolver.resolveHeaders(response.headers());
        //TODO 应该把原来的报文进行保存
        Object result = null;
        //TODO 这个判断应该放到别的地方。
        if(byte[].class.equals(type)){
            result = IOUtils.toByteArray(response.body().asInputStream());
        }else{
            result = super.decode(response, type);
        }

        if(result instanceof WxpayResponseMessageFounder){
            ((WxpayResponseMessageFounder) result).foundWxpayResponseBody(FeignUtil.findResponseBody(response));
            ((WxpayResponseMessageFounder) result).foundWxpayResponseUniqueMessageId(headerResolver.findRequestTraceId(response.headers()));
        }
        return result;
    }

}
