package com.mini.framework.third.weixin.wxpay.v3.client;

import com.mini.framework.third.weixin.wxpay.util.certificate.WxpayMarketCertificateContainer;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.AccountResultFileResponse;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.Html5CreatePayOrderResponse;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.JsApiCreatePayOrderResponse;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.JsApiWebJsRequestBean;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.WxpayCreatePayOrderRequest;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.WxpayQueryPayOrderResponse;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.WxpayRefundPayOrderRequest;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.WxpayRefundPayOrderResponse;
import com.mini.framework.util.asserts.AssertUtil;

/**
 * @author jayheo
 */
public class MarketDirectFeignHttpClientDelegate implements MarketDirectFeignHttpClient{

    private final MarketDirectFeignHttpClient realInstance;
    
    private final WxpayMarketCertificateContainer certificateContainer;


    @Override
    public void applyConfigIfRequire(ClientConfigAttach clientConfigAttach) {
        clientConfigAttach.applyClientConfig(certificateContainer);
    }

    @Override
    public String showCurrentHadMarketKey() {
        return certificateContainer.sureHaveMarketKeyForSignature();
    }

    public MarketDirectFeignHttpClientDelegate(MarketDirectFeignHttpClient realInstance, WxpayMarketCertificateContainer certificateContainer) {
        this.realInstance = realInstance;
        this.certificateContainer = certificateContainer;
    }



    @Override
    public WxpayQueryPayOrderResponse queryPayOrderBySiteOrder(String marketKey, String siteOrderNumber) {
        AssertUtil.assertMethodRequire(marketKey,"marketKey");
        AssertUtil.assertMethodRequire(siteOrderNumber,"siteOrderNumber");
        return realInstance.queryPayOrderBySiteOrder(marketKey,siteOrderNumber);
    }

    @Override
    public WxpayQueryPayOrderResponse queryPayOrderByWxpayOrder(String marketKey, String wxpayOrderNumber) {
        AssertUtil.assertMethodRequire(marketKey,"marketKey");
        AssertUtil.assertMethodRequire(wxpayOrderNumber,"wxpayOrderNumber");
        return realInstance.queryPayOrderByWxpayOrder(marketKey,wxpayOrderNumber);
    }

    @Override
    public WxpayQueryPayOrderResponse closePayOrderBySiteOrder(String marketKey, String siteOrderNumber) {
        AssertUtil.assertMethodRequire(marketKey,"marketKey");
        AssertUtil.assertMethodRequire(siteOrderNumber,"siteOrderNumber");
        return realInstance.closePayOrderBySiteOrder(marketKey, siteOrderNumber);
    }

    @Override
    public WxpayRefundPayOrderResponse executeRefundPayOrder(WxpayRefundPayOrderRequest request) {
        AssertUtil.assertMethodRequire(request,"request");
        //TODO 功能待开发  要和老的功能兼容。
        return realInstance.executeRefundPayOrder(request);
    }

    @Override
    public WxpayRefundPayOrderResponse queryRefundPayOrderBySiteOrder(String siteRefundOrderNumber) {
        AssertUtil.assertMethodRequire(siteRefundOrderNumber,"siteRefundOrderNumber");
        return realInstance.queryRefundPayOrderBySiteOrder(siteRefundOrderNumber);
    }

    @Override
    public AccountResultFileResponse queryDailyHistoryOrdersFile(String day, String tradeType) {
        AssertUtil.assertMethodRequire(day,"day");
        AssertUtil.assertMethodRequire(tradeType,"tradeType");
        return realInstance.queryDailyHistoryOrdersFile(day, tradeType);
    }

    @Override
    public byte[] downloadByteArrayResultFileByTokenTypePath(String path, String token) {
        AssertUtil.assertMethodRequire(path,"path");
        AssertUtil.assertMethodRequire(token,"token");
        return realInstance.downloadByteArrayResultFileByTokenTypePath(path,token);
    }

    @Override
    public Html5CreatePayOrderResponse createHtml5PayOrder(WxpayCreatePayOrderRequest request) {
        AssertUtil.assertMethodRequire(request,"request");
        request.applyClientConfig(certificateContainer);
        return realInstance.createHtml5PayOrder(request);
    }

    @Override
    public JsApiCreatePayOrderResponse createJsApiPayOrder(WxpayCreatePayOrderRequest request) {
        AssertUtil.assertMethodRequire(request,"request");
        request.applyClientConfig(certificateContainer);
        JsApiCreatePayOrderResponse response = realInstance.createJsApiPayOrder(request);
        response.setRequest(request);
        JsApiWebJsRequestBean jsBean = JsApiWebJsRequestBean.fromPayOrderResponse(response);
        jsBean.signatureThenFillResult(certificateContainer.getCertificateContentString());
        response.setJsWebRequest(jsBean);
        return response;
    }
}
