package com.mini.framework.third.weixin.wxpay.v3.model.site;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;
import java.util.function.Supplier;


/**
 * 用户通过公众号号h5支付的请求
 * @author jayheo
 *
 */
public class SiteCreatePayOrderRequest {
    /**
     * 订单号.
     * 这个订单号是学院生成的
     */
    private String orderNumber;

    /**
     * 订单金额.
     */
    private Integer orderAmount;

    /**
     * 订单名字.
     */
    private String orderName;


    private String appid;

    /**
     * 微信openid, 仅微信支付时需要
     */
    private String openid;

    /**
     * 支付成功后的url
     */
    private String resultPushUrl;


	/**
	 * 过期的时间
	 */
	private Date expireDate;

    public SiteCreatePayOrderRequest setOpenidIfRequire(boolean require, Supplier<String> openidSupplier){
    	if(require){
    		setOpenid(openidSupplier.get());
		}
    	return this;
	}

	public SiteCreatePayOrderRequest setExpireDateAfterNow(long expireSeconds){
    	expireDate = new Date(System.currentTimeMillis() + expireSeconds*1000);
    	return this;
	}

	public String getAppid() {
		return appid;
	}

	public void setAppid(String appid) {
		this.appid = appid;
	}

	public String getOrderNumber() {
		return orderNumber;
	}

	public void setOrderNumber(String orderNumber) {
		this.orderNumber = orderNumber;
	}

	public Integer getOrderAmount() {
		return orderAmount;
	}

	public void setOrderAmount(Integer orderAmount) {
		this.orderAmount = orderAmount;
	}

	public String getOrderName() {
		return orderName;
	}

	public void setOrderName(String orderName) {
		this.orderName = orderName;
	}

	public String getOpenid() {
		return openid;
	}

	public void setOpenid(String openid) {
		this.openid = openid;
	}

	public String getResultPushUrl() {
		return resultPushUrl;
	}

	public void setResultPushUrl(String resultPushUrl) {
		this.resultPushUrl = resultPushUrl;
	}

	public Date getExpireDate() {
		return expireDate;
	}

	public void setExpireDate(Date expireDate) {
		this.expireDate = expireDate;
	}

	@Override
    public String toString() {

		return ToStringBuilder.reflectionToString(this,ToStringStyle.SHORT_PREFIX_STYLE);
    }
    
    

}
