package com.mini.framework.third.weixin.wxpay.v3.model.weixin;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.util.asserts.AssertUtil;
import org.apache.commons.lang3.StringUtils;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

/**
 * 对账记录文件的响应
 * @author jayheo
 */
public class AccountResultFileResponse extends WxpayResponse {


    @SerializedName("download_url")
    private String resourceUrl;

    @SerializedName("hash_value")
    private String fileHashValue;

    @SerializedName("hash_type")
    private String fileHashType;

    public static Optional< String> findUrlParamByName(String url,String name){
        return Optional.ofNullable(findUrlParams(url).get(name));
    }


    public static Map<String, String> findUrlParams(String url){
        String queries = StringUtils.substringAfter(url, "?");
        Map<String,String> params = new LinkedHashMap<>();
        Stream.of(queries.split("&")).forEach(item->{
            String[] nameValue = item.split("=");
            if(nameValue.length>1){
                params.put(nameValue[0],nameValue[1]);
            }
        });
        return params;
    }

    public Optional<String> queryTokenOfResourceUrl(){
        return findUrlParamByName(resourceUrl,"token");
    }


    public Optional<String> queryTarTypeOfResourceUrl(){
        return findUrlParamByName(resourceUrl,"tartype");
    }

    public String getPathOfResourceUrl(){
        return StringUtils.substringBefore(getFullOfResourceUrl(), "?");
    }


    public String getFullOfResourceUrl(){
        AssertUtil.assertMethodRequire(resourceUrl,"resourceUrl");
        String temp = resourceUrl;
        temp = temp.replaceFirst("/","");
        temp = temp.replaceFirst("/","");
        int offset = temp.indexOf("/");
        return temp.substring(offset);
    }

    public String getResourceUrl() {
        return resourceUrl;
    }

    public void setResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
    }

    public String getFileHashValue() {
        return fileHashValue;
    }

    public void setFileHashValue(String fileHashValue) {
        this.fileHashValue = fileHashValue;
    }

    public String getFileHashType() {
        return fileHashType;
    }

    public void setFileHashType(String fileHashType) {
        this.fileHashType = fileHashType;
    }
}
