package com.mini.framework.third.weixin.wxpay.v3.model.weixin;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;

/**
 * https://pay.weixin.qq.com/wiki/doc/apiv3/apis/chapter3_1_4.shtml
 * @author jayheo
 */
public class JsApiCreatePayOrderResponse extends WxpayResponse implements ClientUsefulCreatePayOrderResponse  {
    
    @SerializedName("prepay_id")
    private String packageId;

    private WxpayCreatePayOrderRequest request;

    private JsApiWebJsRequestBean jsWebRequest;

    public WxpayCreatePayOrderRequest getRequest() {
        return request;
    }

    public void setRequest(WxpayCreatePayOrderRequest request) {
        this.request = request;
    }

    public JsApiWebJsRequestBean getJsWebRequest() {
        return jsWebRequest;
    }

    public void setJsWebRequest(JsApiWebJsRequestBean jsWebRequest) {
        this.jsWebRequest = jsWebRequest;
    }

    public String getPackageId() {
        return packageId;
    }

    public void setPackageId(String packageId) {
        this.packageId = packageId;
    }

    @Override
    public String createClientPayRequestJson() {
        return ClientUsefulCreatePayOrderResponse.createGsonUtil().toJson(jsWebRequest);
    }
}
