package com.mini.framework.third.ali.ai.config;

import com.google.gson.Gson;
import com.mini.framework.third.ali.ai.model.BcardIdenitifyResponse;
import com.mini.framework.third.ali.ai.type.AliyunProductType;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.http.SimpleHttpPostReqer;
import com.mini.framework.util.paas.MultiSiteConfig;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

import java.util.HashMap;
import java.util.Map;

/**
 * 阿里云服务帮助类.
 *
 * @author riefu233
 */
public class AliyunServiceHelper {

    private static Logger logger = LogManager.getLogger(AliyunServiceHelper.class);


    private MultiSiteConfig<Integer, Map<String, AliyunAccessConfig>> siteAliyunConfig;

    public AliyunServiceHelper(MultiSiteConfig<Integer, Map<String, AliyunAccessConfig>> siteAliyunConfig) {
        this.siteAliyunConfig = siteAliyunConfig;
    }

    public BcardIdenitifyResponse bcardIdentify(String imgBase64) {

        AliyunAccessConfig aliyunAccessConfig = this.siteAliyunConfig.currBean().get(AliyunProductType.bcard.name());
        AssertUtil.assertGetHaveData(aliyunAccessConfig != null, "商户 [%s] 未开通名片识别服务", this.siteAliyunConfig.getSiteIdReader().currSiteId());
        HashMap<Object, Object> config = new HashMap<>();
        config.put("site", "face");

        HashMap<String, String> headers = new HashMap<>();
        headers.put("Authorization", "APPCODE " + aliyunAccessConfig.getAppCode());
        headers.put("Content-Type", "application/json; charset=UTF-8");

        HashMap<String, String> body = new HashMap<>();
        body.put("configure", new Gson().toJson(config));
        body.put("image", imgBase64);
        String bodyJson = new Gson().toJson(body);
        String req = new SimpleHttpPostReqer(bodyJson, headers).req(aliyunAccessConfig.getApi());

        BcardIdenitifyResponse bcardIdenitifyResponse = new Gson().fromJson(req, BcardIdenitifyResponse.class);
        return bcardIdenitifyResponse;

    }

}
