package com.mini.framework.third.aliyun.model.content;

import java.util.List;
import java.util.Optional;

import com.mini.framework.core.exception.BadReqGetNoDataException;
import com.mini.framework.third.aliyun.model.AbstractAliyunResponse;
import com.mini.framework.third.aliyun.model.content.photo.PhotoTask;
import com.mini.framework.third.aliyun.model.content.type.Suggestion;
import com.mini.framework.util.function.PredicateSpread;

public class ContentGreenPhotoResponse extends AbstractAliyunResponse {

	private List<PhotoTask> data;

	public List<PhotoTask> getData() {
		return data;
	}

	public void setData(List<PhotoTask> data) {
		this.data = data;
	}
	
	public String mapperDataId(String url){
		return data.stream().filter(PredicateSpread.isEqual(PhotoTask::getUrl, url))
				.findFirst().map(PhotoTask::getDataId)
				.orElseThrow(()->new BadReqGetNoDataException("不存在url:[%s]对应的任务id", url));
	}

	public Optional<PhotoTask> showDataIdByUrl(String url) {
		return showDataIdByUrl(mapperDataId(url));
	}
	
	public Optional<PhotoTask> showTask(String dataId) {
		if (data!=null) {
			return data.stream().filter(PredicateSpread.isEqual(PhotoTask::getDataId, dataId)).findFirst();
		} else {
			return Optional.empty();
		}
	}
	

	public Optional<SuggestionResult> showResultByUrl( String url) {
		return showResult(mapperDataId(url));
	}

	
	public Optional<SuggestionResult> showSeriousResult() {
		if (data!=null) {
			 return data.stream().map(PhotoTask::showResult).filter(Optional::isPresent).map(Optional::get)
					.filter(SuggestionResult::notPass).sorted(SuggestionResult.seriousSorter().reversed()).findFirst();
		} else {
			return Optional.empty();
		}
	}

	public Optional<SuggestionResult> showResult(String dataId) {
		return showTask(dataId).map(PhotoTask::showResult).map(Optional::get);
	}

	public Optional<Suggestion> showSuggestionByUrl(String url) {
		return showSuggestion(mapperDataId(url));
	}
	
	
	public Optional<Suggestion> showSuggestion(String dataId) {
		Optional<PhotoTask> taskOptional = showTask(dataId);
		if(taskOptional.isPresent()){
			return taskOptional.get().showSuggestion();
		}
		return Optional.of(Suggestion.review);
	}

}
