package com.mini.framework.third.aliyun.model.content;

import java.util.Comparator;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.mini.framework.third.aliyun.model.content.type.Suggestion;

public class SuggestionResult {

	private Suggestion suggestion;

	private String cause;
	
	

	public SuggestionResult() {
		super();
	}

	public SuggestionResult(Suggestion suggestion, String cause) {
		super();
		this.suggestion = suggestion;
		this.cause = cause;
	}

	public Suggestion getSuggestion() {
		return suggestion;
	}

	public void setSuggestion(Suggestion suggestion) {
		this.suggestion = suggestion;
	}

	public String getCause() {
		return cause;
	}

	public void setCause(String cause) {
		this.cause = cause;
	}
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
	
	public boolean notPass(){
		return !pass();
	}
	public boolean pass(){
		return suggestion.pass();
	}
	
	public static Comparator<SuggestionResult> seriousSorter(){
		return Comparator.comparing(SuggestionResult::getSuggestion, Suggestion.seriousSorter());
	}

}
