package com.mini.framework.third.aliyun.model.content.text;

//https://help.aliyun.com/document_detail/70439.html?spm=a2c4g.11186623.2.12.64853db3cffDt7#reuse-scene
/**
 * 垃圾文本检测的垃圾类型
 * @author jayheo
 *
 */
public enum TextAntispamSceneItem {
	
	normal	("正常文本",50.0),
	spam("含垃圾信息",99.99),
	ad("广告",99.99),
	politics("涉政",99.99),
	terrorism("暴恐",90.0),
	abuse("辱骂",90.0),
	porn("色情",90.0),
	flood("灌水",99.99),
	contraband("违禁",99.99),
	meaningless("无意义",99.99),
	customized("未知",99.99),
	;
	
	private Double allowRate;
	
	private String desc;

	private TextAntispamSceneItem(String desc,Double allowRate) {
		this.desc = desc;
		this.allowRate = allowRate;
	}
	
	public String desc(){
		return desc;
	}
	
	public boolean ifBlack(double rate){
		return !this.equals(normal) && rate>allowRate;
	}
	
	public String simpleDesc(){
		return String.format("%s(%s>=%s)", desc,this.name(),allowRate);
	}
}
