package com.mini.framework.third.cl253.comm;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.google.gson.annotations.SerializedName;

/**
 * 发送知识消息的请求
 * @author jayheo
 *
 */
public class SendSmsCommRequest {

	@SerializedName("account")
    private String account;

	@SerializedName("password")
    private String passwd;

	@SerializedName("msg")
    private String message;

	@SerializedName("phone")
    private String phone;

	@SerializedName("report")
    private boolean requireNotice;

	@SerializedName("extend")
    private String extend = "01";

	/**
	 * 用来跟踪消息的id
	 */
	@SerializedName("uid")
    private String traceId;
	
	/**
	 * 计划发送消息的时间
	 */
	@SerializedName("sendtime")
	private String sendDate;

	public String getAccount() {
		return account;
	}

	public void setAccount(String account) {
		this.account = account;
	}

	public String getPasswd() {
		return passwd;
	}

	public void setPasswd(String passwd) {
		this.passwd = passwd;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public String getPhone() {
		return phone;
	}
	
	public void setPhones(String... phone) {
		this.phone = String.join(",",phone);
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public boolean isRequireNotice() {
		return requireNotice;
	}

	public void setRequireNotice(boolean requireNotice) {
		this.requireNotice = requireNotice;
	}

	public String getExtend() {
		return extend;
	}

	public void setExtend(String extend) {
		this.extend = extend;
	}

	public String getTraceId() {
		return traceId;
	}

	public void setTraceId(String traceId) {
		this.traceId = traceId;
	}

	public String getSendDate() {
		return sendDate;
	}

	public void setSendDate(String sendDate) {
		this.sendDate = sendDate;
	}
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
    
/*    {
        "account": "N6000001",
        "password": "123456",
        "msg": "【三九课堂】您的验证码是：2530",
        "phone": "15800000000",
        "sendtime": "201704101400",
        "report": "true",
        "extend": "555",
        "uid": "321abc"
    }*/
}
