package com.mini.framework.third.cl253.model;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.mini.framework.core.exception.BadReqException;
import com.mini.framework.third.cl253.comm.SendSmsCommRequest;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.string.RegexUtil;

/**
 * 发送短消息的请求
 * @author jayheo
 *
 */
public class SendSmsRequest {

	/**
	 * 站点的签名
	 */
	private String siteSign;

	/**
	 * 消息的的内容
	 */
	private String content;
	
	
	private String[] phones;

	public String getSiteSign() {
		return siteSign;
	}

	public void setSiteSign(String siteSign) {
		this.siteSign = siteSign;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}
	
	public String[] getPhones() {
		return phones;
	}

	public void setPhones(String[] phones) {
		this.phones = phones;
	}

	public SendSmsRequest() {
		super();
	}


	public static SendSmsRequest fromCommand(String command) {
		return fromCommand(command, "@@");
	}
	
	/**
	 * 通过命令语句得到地短信请求
	 * @param command
	 * @return
	 */
	public static SendSmsRequest fromCommand(String command,String split) {
		AssertUtil.assertMethodRequire(command, "command");
		AssertUtil.assertMethodRequire(split, "split");
		String regex = String .format("([^%s]*)%s([^%s]*)%s([0-9,]*)", split, split, split, split);
		String[] items = RegexUtil.getMatch(regex, command, 1,2,3);
		if(items==null){
			throw new BadReqException("短信命令不符合规范command:[%s]", command);
		}else{
			return new SendSmsRequest(items[0], items[1], items[2].split(","));
		}
	}
	
	public SendSmsRequest(String siteSign, String content, String... phones) {
		super();
		this.siteSign = siteSign;
		this.content = content;
		this.phones = phones;
	}

	public SendSmsCommRequest createCommReq(){
		String message = String.format("【%s】%s",siteSign,content);
		SendSmsCommRequest commReq = new SendSmsCommRequest();
		commReq.setMessage(message);
		commReq.setPhones(phones);
		return commReq;
	}
	
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
	
}
