package com.mini.framework.third.kuaidi100;

import org.apache.commons.codec.digest.DigestUtils;

import com.mini.framework.third.kuaidi100.model.ExpressStatusResponse;
import com.mini.framework.third.kuaidi100.model.StatusSubscribeResponse;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.http.SimpleHttpUtil;
import com.mini.framework.util.params.MapParams;
import com.mini.framework.util.string.gson.builder.GsonData;

public class Kuaidi100Client {

	private Kuaidi100Client(){
		
	}
	
	public static Kuaidi100Client build(){
		return new Kuaidi100Client();
	}
	
	//https://poll.kuaidi100.com/manager/page/debugtools/subscribe
	
	public StatusSubscribeResponse createSubscribePoll(String accessKey,String company,String number,String callbackurl){
		String url = "https://poll.kuaidi100.com/poll";
		AssertUtil.assertMethodRequire(accessKey, "accessKey");
		AssertUtil.assertMethodRequire(company, "company");
		AssertUtil.assertMethodRequire(number, "number");
		AssertUtil.assertMethodRequire(callbackurl, "callbackurl");
		String param = GsonData.build().param("company", company).param("number", number).param("key", accessKey)
		.object("parameters", parameters->parameters.param("callbackurl", callbackurl)).toJson();
		String result = SimpleHttpUtil.simpleGet(url ,MapParams.build("schema", "json").param("param", param).toStringMap());
		return StatusSubscribeResponse.fromJson(result);
	}
	
	
	public ExpressStatusResponse queryCurrentStatus(String customer,String accessKey,String company,String number){
		String url = "https://poll.kuaidi100.com/poll/query.do";
		AssertUtil.assertMethodRequire(customer, "customer");
		AssertUtil.assertMethodRequire(accessKey, "accessKey");
		AssertUtil.assertMethodRequire(company, "company");
		AssertUtil.assertMethodRequire(number, "number");
		String param = GsonData.build().param("com", company).param("num", number).toJson();
		String sign = DigestUtils.md5Hex(param + accessKey  + customer).toUpperCase();
		String result = SimpleHttpUtil.simpleGet(url ,MapParams.build("customer", customer).param("sign", sign).param("param", param).toStringMap());
		return ExpressStatusResponse.fromJson(result);
		
		//GsonData.build().param("customer", customer).param(key, value)
		
	}
	
	
	
	
	
}
