package com.mini.framework.third.weixin.mapp.model;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

import com.mini.framework.util.asserts.AssertUtil;

/**
 * 登录小程序的场景key
 * https://developers.weixin.qq.com/miniprogram/dev/framework/app-service/scene.html
 * @author jayheo
 *
 */
public enum LaunchSceneKey {
	//TODO 杨笑翔帮我把这个文档优化一下，主要也是熟悉一下场景

	k1000("1000", "未知场景", "微信文档中没有这个场景但是测试的时候有"), //
	k1001("1001", "发现栏小程序主入口「我的小程序」列表", "发现栏小程序主入口，「最近使用」列表（基础库2.2.4版本起包含「我的小程序」列表）"), //
	k1005("1005", "顶部搜索框的搜索结果页", "顶部搜索框的搜索结果页"), //
	k1006("1006", "发现栏小程序主入口搜索框的搜索结果页", "发现栏小程序主入口搜索框的搜索结果页"), //
	k1007("1007", "单人聊天会话中的小程序消息卡片", "单人聊天会话中的小程序消息卡片"), //
	k1008("1008", "群聊会话中的小程序消息卡片", "群聊会话中的小程序消息卡片"), //
	k1011("1011", "扫描二维码", "扫描二维码"), //
	k1012("1012", "长按图片识别二维码", "长按图片识别二维码"), //
	k1013("1013", "手机相册选取二维码", "手机相册选取二维码"), //
	k1014("1014", "小程序模板消息", "小程序模板消息"), //
	k1017("1017", "前往体验版的入口页", "前往体验版的入口页"), //
	k1019("1019", "微信钱包", "微信钱包"), //
	k1020("1020", "公众号profile页相关小程序列表", "公众号profile页相关小程序列表"), //
	k1022("1022", "聊天顶部置顶小程序入口", "聊天顶部置顶小程序入口"), //
	k1023("1023", "安卓系统桌面图标", "安卓系统桌面图标"), //
	k1024("1024", "小程序profile页", "小程序profile页"), //
	k1025("1025", "扫描一维码", "扫描一维码"), //
	k1026("1026", "附近小程序列表", "附近小程序列表"), //
	k1027("1027", "顶部搜索框搜索结果页「使用过的小程序」列表", "顶部搜索框搜索结果页「使用过的小程序」列表"), //
	k1028("1028", "我的卡包", "我的卡包"), //
	k1029("1029", "卡券详情页", "卡券详情页"), //
	k1030("1030", "自动化测试下打开小程序", "自动化测试下打开小程序"), //
	k1031("1031", "长按图片识别一维码", "长按图片识别一维码"), //
	k1032("1032", "手机相册选取一维码", "手机相册选取一维码"), //
	k1034("1034", "微信支付完成页", "微信支付完成页"), //
	k1035("1035", "公众号自定义菜单", "公众号自定义菜单"), //
	k1036("1036", "App分享消息卡片", "App分享消息卡片"), //
	k1037("1037", "小程序打开小程序", "小程序打开小程序"), //
	k1038("1038", "从另一个小程序返回", "从另一个小程序返回"), //
	k1039("1039", "摇电视", "摇电视"), //
	k1042("1042", "添加好友搜索框的搜索结果页", "添加好友搜索框的搜索结果页"), //
	k1043("1043", "公众号模板消息", "公众号模板消息"), //
	k1044("1044", "带shareTicket的小程序消息卡片详情", "带shareTicket的小程序消息卡片详情"), //
	k1045("1045", "朋友圈广告", "朋友圈广告"), //
	k1046("1046", "朋友圈广告详情页", "朋友圈广告详情页"), //
	k1047("1047", "扫描小程序码", "扫描小程序码"), //
	k1048("1048", "长按图片识别小程序码", "长按图片识别小程序码"), //
	k1049("1049", "手机相册选取小程序码", "手机相册选取小程序码"), //
	k1052("1052", "卡券的适用门店列表", "卡券的适用门店列表"), //
	k1053("1053", "搜一搜的结果页", "搜一搜的结果页"), //
	k1054("1054", "顶部搜索框小程序快捷入口", "顶部搜索框小程序快捷入口"), //
	k1056("1056", "音乐播放器菜单", "音乐播放器菜单"), //
	k1057("1057", "钱包中的银行卡详情页", "钱包中的银行卡详情页"), //
	k1058("1058", "公众号文章", "公众号文章"), //
	k1059("1059", "体验版小程序绑定邀请页", "体验版小程序绑定邀请页"), //
	k1064("1064", "微信连Wi-Fi状态栏", "微信连Wi-Fi状态栏"), //
	k1067("1067", "公众号文章广告", "公众号文章广告"), //
	k1068("1068", "附近小程序列表广告", "附近小程序列表广告"), //
	k1069("1069", "移动应用", "移动应用"), //
	k1071("1071", "钱包中的银行卡列表页", "钱包中的银行卡列表页"), //
	k1072("1072", "二维码收款页面", "二维码收款页面"), //
	k1073("1073", "客服消息列表下发的小程序消息卡片", "客服消息列表下发的小程序消息卡片"), //
	k1074("1074", "公众号会话下发的小程序消息卡片", "公众号会话下发的小程序消息卡片"), //
	k1077("1077", "摇周边", "摇周边"), //
	k1078("1078", "连Wi-Fi成功页", "连Wi-Fi成功页"), //
	k1079("1079", "微信游戏中心", "微信游戏中心"), //
	k1081("1081", "客服消息下发的文字链", "客服消息下发的文字链"), //
	k1082("1082", "公众号会话下发的文字链", "公众号会话下发的文字链"), //
	k1084("1084", "朋友圈广告原生页", "朋友圈广告原生页"), //
	k1089("1089", "微信聊天主界面下拉，「最近使用」栏（基础库2.2.4版本起包含「我的小程序」栏）", "微信聊天主界面下拉，「最近使用」栏（基础库2.2.4版本起包含「我的小程序」栏）"), //
	k1090("1090", "长按小程序右上角菜单唤出最近使用历史", "长按小程序右上角菜单唤出最近使用历史"), //
	k1091("1091", "公众号文章商品卡片", "公众号文章商品卡片"), //
	k1092("1092", "城市服务入口", "城市服务入口"), //
	k1095("1095", "小程序广告组件", "小程序广告组件"), //
	k1096("1096", "聊天记录", "聊天记录"), //
	k1097("1097", "微信支付签约页", "微信支付签约页"), //
	k1099("1099", "页面内嵌插件", "页面内嵌插件"), //
	k1102("1102", "公众号profile页服务预览", "公众号profile页服务预览"), //
	k1103("1103", "发现栏小程序主入口，「我的小程序」列表（基础库2.2.4版本起废弃）", "发现栏小程序主入口，「我的小程序」列表（基础库2.2.4版本起废弃）"), //
	k1104("1104", "微信聊天主界面下拉，「我的小程序」栏（基础库2.2.4版本起废弃）", "微信聊天主界面下拉，「我的小程序」栏（基础库2.2.4版本起废弃）"), //
	kUnknown("0","未知场景","未知场景，这是一个默认的场景")
	;
	private String key;

	private String title;

	private String desc;

	public String getKey() {
		return key;
	}

	public String getTitle() {
		return title;
	}

	public String getDesc() {
		return desc;
	}
	
	public Map<String, Object> toBeanDesc(){
		Map<String, Object> beanDesc = new LinkedHashMap<String, Object>();
		beanDesc.put("key", key);
		beanDesc.put("title", title);
		beanDesc.put("desc", desc);
		return beanDesc ;
	}


	private LaunchSceneKey(String key, String title, String desc) {
		this.key = key;
		this.title = title;
		this.desc = desc;
	}
	
	public boolean matchKey(String key){
		AssertUtil.assertMethodRequire(key, "key");
		return this.key.equals(key);
	}

	public static Optional<LaunchSceneKey> valueOfKey(String targetKey) {
		AssertUtil.assertMethodRequire(targetKey, "targetKey");
		return Stream.of(values()).filter(value->value.matchKey(targetKey)).findFirst();
	}

}
