package com.mini.framework.third.weixin.notice.server.handler;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.mini.framework.util.log.Event5WBuilder;
import com.mini.framework.third.weixin.notice.server.model.WeixinNoticeType;
import com.mini.framework.third.weixin.notice.server.model.WeixinOpenidSureResult;
import com.mini.framework.third.weixin.notice.server.model.resp.EventScanCodeNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.EventTemplateResultNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.EventUnSubscribeNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.EventViewNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.EventWeixinAwakeSessionNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.FileNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.LocationNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.TextNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.VoiceNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.WeixinAskMsg;

public class SimpleWeixinServerNoticeHandler extends AbstractWeixinServerNoticeHandler{

	private Logger logger = LogManager.getLogger(SimpleWeixinServerNoticeHandler.class);
	
	@Override
	protected void handleLocation(LocationNotice weixinNotice, WeixinAskMsg weixinAskMsg) {
		Event5WBuilder event = Event5WBuilder.event(1, "weixinPushUnhandle").what("收到没有处理的微信推送:%s", weixinNotice);
		logger.debug(event);
	}

	@Override
	protected void handleFile(FileNotice weixinNotice, WeixinAskMsg weixinAskMsg) {
		// TODO Auto-generated method stub
		
	}

	@Override
	protected void handleEvent(EventUnSubscribeNotice weixinNotice, WeixinAskMsg weixinAskMsg) {
		// TODO Auto-generated method stub
		
	}


	@Override
	protected void handleEvent(EventViewNotice eventNotice, WeixinAskMsg weixinAskMsg) {
		// TODO Auto-generated method stub
		
	}

	@Override
	protected void handleEvent(EventScanCodeNotice weixinNotice, WeixinAskMsg weixinAskMsg) {
		// TODO Auto-generated method stub
		
	}

	@Override
	protected void handleText(TextNotice textNotice, WeixinAskMsg weixinAskMsg) {
		// TODO Auto-generated method stub
		
	}

	@Override
	protected void handleVoice(VoiceNotice voiceNotice, WeixinAskMsg weixinAskMsg) {
		// TODO Auto-generated method stub
		
	}

	@Override
	protected void handleSceneInvite(WeixinNoticeType weixinNoticeType, WeixinOpenidSureResult openid, String inviteCode) {
		// TODO Auto-generated method stub
		
	}

	@Override
	protected void handleSubscribe(WeixinOpenidSureResult openid) {
		// TODO Auto-generated method stub
		
	}

	@Override
	protected void handleEvent(EventTemplateResultNotice weixinNotice, WeixinAskMsg weixinAskMsg) {
		// TODO Auto-generated method stub
		
	}

	@Override
	protected void handleEvent(EventWeixinAwakeSessionNotice weixinNotice, WeixinAskMsg weixinAskMsg) {
		// TODO Auto-generated method stub
		
	}

}
