package com.mini.framework.third.weixin.notice.server.model.resp;

import com.thoughtworks.xstream.annotations.XStreamAlias;


/*
 * 报文示例
<xml><ToUserName><![CDATA[gh_5f8a403a7e91]]></ToUserName>
<FromUserName><![CDATA[oDmGI1T65oFagp_oWWNz-KMOfaZE]]></FromUserName>
<CreateTime>1521860076</CreateTime>
<MsgType><![CDATA[event]]></MsgType>
<Event><![CDATA[VIEW]]></Event>
<EventKey><![CDATA[https://study-dev.aquke.com]]></EventKey>
<MenuId>444211872</MenuId>
</xml> 
 * */

@XStreamAlias("xml")
public class EventViewNotice extends EventNotice{
	/**
	 * 菜单id
	 */
	@XStreamAlias("MenuId")
	private String menuId;
	

	public String getMenuId() {
		return menuId;
	}

	public void setMenuId(String menuId) {
		this.menuId = menuId;
	}

	/**
	 * eventKey 代表url
	 * @return
	 */
	public String getViewUrl(){
		return super.getEventKey();
	}
	
}
