package com.mini.framework.third.weixin.notice.server.model.resp;

import com.thoughtworks.xstream.annotations.XStreamAlias;


/*
https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421140453
<xml> <ToUserName>< ![CDATA[toUser] ]></ToUserName> <FromUserName>< ![CDATA[fromUser] ]></FromUserName> <CreateTime>1348831860</CreateTime> <MsgType>< ![CDATA[image] ]></MsgType> <PicUrl>< ![CDATA[this is a url] ]></PicUrl> <MediaId>< ![CDATA[media_id] ]></MediaId> <MsgId>1234567890123456</MsgId> </xml>
ToUserName	开发者微信号
FromUserName	发送方帐号（一个OpenID）
CreateTime	消息创建时间 （整型）
MsgType	image
PicUrl	图片链接（由系统生成）
MediaId	图片消息媒体id，可以调用多媒体文件下载接口拉取数据。
MsgId	消息id，64位整型

*/
/**
 * 微信的图标通知
 * @author jayheo
 *
 */
@XStreamAlias("xml")
public class ImageNotice extends WeixinNotice{
	@XStreamAlias("PicUrl")
	private String picUrl;
	
	@XStreamAlias("MediaId")
	private String mediaId;

	public String getPicUrl() {
		return picUrl;
	}

	public void setPicUrl(String picUrl) {
		this.picUrl = picUrl;
	}

	public String getMediaId() {
		return mediaId;
	}

	public void setMediaId(String mediaId) {
		this.mediaId = mediaId;
	}

}
