package com.mini.framework.third.weixin.notice.server.util;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.string.RegexUtil;
import com.mini.framework.third.weixin.notice.server.model.WeixinNoticeType;
import com.mini.framework.third.weixin.notice.server.model.resp.ServerAndUserShower;
import com.mini.framework.third.weixin.notice.server.model.resp.WeixinAskMsg;
import com.mini.framework.third.weixin.notice.server.model.resp.WeixinNotice;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;

/**
 * 微信通知消息工厂<br>
 * @author jayheo
 *
 */
public class WeixinNoticeMsgFactory {
	
	private static final String msgTypeNodeKey = "MsgType";
	private static final String eventNodeKey = "Event";
	private static final String fromNodeKey = "FromUserName";
	private static final String toNodeKey = "ToUserName";
	
	/**
	 * 读xml消息字符串得到java bean<br>
	 * @param xmlNotice
	 * @return
	 */
	public static WeixinNotice readXmlNotice(String xmlNotice){
		String type = RegexUtil.xmlRegexNodeValue(msgTypeNodeKey, xmlNotice);
		String subType = RegexUtil.xmlRegexNodeValue(eventNodeKey, xmlNotice);
		
		
		AssertUtil.assertNotNull(type, "没有解析到通知类型,xmlNotice:%s", xmlNotice);
		if("event".equals(type)){
			type+="." + subType;
		}
		
		WeixinNoticeType noticeType = WeixinNoticeType.get(type);
		AssertUtil.assertNotNull(noticeType, "没有与%s对应的实体类", type);
		XStream xstream = new XStream(new DomDriver("utf-8"));
		AssertUtil.assertNotNull(noticeType.getClazz(), "%s的class不能为空", noticeType);
		xstream.processAnnotations(noticeType.getClazz());
		xstream .autodetectAnnotations(true);
		WeixinNotice weixinNotice = (WeixinNotice)xstream.fromXML(xmlNotice);
		weixinNotice.setOriginXmlMessage(xmlNotice);
		//fillShower(xmlNotice,weixinNotice);
		weixinNotice.setWeixinNoticeType(noticeType);
		return  weixinNotice;
	}
	
	
	//TODO 这里可能会有错误,from和to可能会错位
	public static void fillShower(String xmlNotice, ServerAndUserShower shower) {
		String to = RegexUtil.xmlRegexNodeValue(toNodeKey, xmlNotice);
		String from = RegexUtil.xmlRegexNodeValue(fromNodeKey, xmlNotice);
		shower.setServAcc(to);
		shower.setOpenid(from);		
	}


	/**
	 * 把javabean转成xml字符串<br>
	 * @param weixinAskMsg
	 * @return
	 */
	public static String toXmlAsk(WeixinAskMsg weixinAskMsg){
		XStream xstream = new XStream(new DomDriver("utf-8"));
		xstream.processAnnotations(WeixinAskMsg.class);
		xstream .autodetectAnnotations(true);
		String xml = xstream.toXML(weixinAskMsg);
		return xml;
	}


	/**
	 * 从报文中拿到微信帐号
	 * @param body
	 * @return
	 */
	public static String showAccount(String body) {
		String to = RegexUtil.xmlRegexNodeValue(toNodeKey, body);
		//<xml><ToUserName><![CDATA[gh_5f8a403a7e91]]></ToUserName>
		//目前认为 这个 ToUserName就是微信公众号的帐号TODO 如果这里出现null要注意
		return to;
	}


	/**
	 * 从报文中拿到发起动作微信openid
	 * @param body
	 * @return
	 */
	public static String showOpenid(String body) {
		String from = RegexUtil.xmlRegexNodeValue(fromNodeKey, body);
		return from;
	}

}
