package com.mini.framework.third.weixin.pay.model;


import com.mini.framework.core.status.Status;
import com.mini.framework.core.status.StatusCode;
import com.mini.framework.util.asserts.AssertUtil;

import java.util.stream.Stream;

/**
 * 微信支付响应状态码枚举.
 *
 * @author riefu233
 */
public enum SitePayStatusType {

    /**
     * 提现支付配置错误.
     **/
    withdrawConfigErr(new String[]{"NO_AUTH", "PAY_CHANNEL_NOT_ALLOWED", "AMOUNT_LIMIT", "SIGN_ERROR", "MONEY_LIMIT", "CA_ERROR", "RECV_ACCOUNT_NOT_ALLOWED"}, Status.Third.siteWithdrawConfigErr),

    /**
     * 商户余额不足.
     */
    siteBalanceNotEnough(new String[]{"NOTENOUGH"}, Status.Third.siteBalanceNotEnough),

    /**
     *
     * 指定单号数据不存在
     */
    siteWithNoNotFound(new String[]{"NOT_FOUND"},Status.Third.wxPayNoNotFound),

    /**
     * 付款错误，发生该错误请调用企业支付订单查询接口查询该笔订单是否支付成功,以查询结果为准.
     */
    sitePayErr(new String[]{"SEND_FAILED"},Status.Third.wxPayErr),

    /**
     * 支付请求异常.
     **/
    reqErr(new String[]{"PARAM_ERROR", "OPENID_ERROR", "XML_ERROR", "FATAL_ERROR", "FREQ_LIMIT", "PARAM_IS_NOT_UTF8", "V2_ACCOUNT_SIMPLE_BAN", "SENDNUM_LIMIT"}, Status.Third.wxPay),

    /**
     * 微信支付服务器异常.
     **/
    wxServerErr(new String[]{"SYSTEMERROR"}, Status.Third.wxPayServerErr),;

    /** 微信支付响应状态. **/
    private String[] wxErrCodes;

    /** 业务状态码. **/
    private StatusCode selfStatusCode;


    SitePayStatusType(String[] wxErrCodes, StatusCode selfStatusCode) {
        this.wxErrCodes = wxErrCodes;
        this.selfStatusCode = selfStatusCode;
    }


    /**
     *  将微信响应的状态码映射成系统自身的业务状态码.
     *
     * @param statusResp 微信响应状态码.
     * @return SitePayStatusType
     */
    public static SitePayStatusType weixinPublicStatus(String statusResp) {
        AssertUtil.assertMethodRequire(statusResp, "statusResp");
        SitePayStatusType mapStatus = Stream.of(SitePayStatusType.values())
                .filter(status -> Stream.of(status.wxErrCodes).filter(map -> map.equals(statusResp)).count() == 1).findFirst().orElse(null);
        return mapStatus;
    }

    public String[] getWxErrCodes() {
        return wxErrCodes;
    }

    public StatusCode getMap() {
        return selfStatusCode;
    }}
