package com.mini.framework.third.weixin.pay.type;

import java.util.stream.Stream;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.core.status.Status;


/**
 * 微信支付类型
 * @author jayheo
 *
 */
public enum WeixinPayType {

    WXPAY_H5("wxpay_h5", "微信公众账号支付","JSAPI"),

    WXPAY_MWEB("MWEB", "微信公众账号支付" ,"MWEB"),
    ;
    
    private String tradeType;

    private String code;

    private String name;

    WeixinPayType(String code, String name,String tradeType) {
        this.code = code;
        this.name = name;
        this.tradeType = tradeType;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public String getTradeType() {
		return tradeType;
	}

	public static WeixinPayType getByCode(String code) {
    	WeixinPayType type = Stream.of(WeixinPayType.values()).filter(oneType->oneType.code.equals(code)).findAny().orElse(null);
    	AssertUtil.assertNoBadReq(type!=null, Status.BadReq.illParam, "找不到:[%s]对应的支付类型", code);
    	return type;
    }
}
