package com.mini.framework.third.weixin.server.util.tpmsg;

import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.builder.ToStringBuilder;

// https://mp.weixin.qq.com/advanced/tmplmsg?action=tmpl_store&token=542946430&lang=zh_CN#page=1&keyword=
/**
 * @author jayheo 模版消息 微信上的文档
 */
public class WeixinTempDoc {

	/**
	 * 微信编号 TM00001
	 */
	private String docId;

	/**
	 * 标题 购买成功通知
	 */
	private String title;
	
	private String industry;

	/**
	 * 最后修改时间
	 */
	private Date lastEdit;

	/**
	 * 文档中的详细内容
	 */
	private String example;

	/**
	 * 例子变量可以更换key的字符串
	 */
	private String exampleReplace;

	private List<TempKeyword> keywords;

	public String getDocId() {
		return docId;
	}

	public void setDocId(String docId) {
		this.docId = docId;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Date getLastEdit() {
		return lastEdit;
	}

	public void setLastEdit(Date lastEdit) {
		this.lastEdit = lastEdit;
	}

	public String getExample() {
		return example;
	}

	public void setExample(String example) {
		this.example = example;
	}

	public List<TempKeyword> getKeywords() {
		return keywords;
	}

	public void setKeywords(List<TempKeyword> keywords) {
		this.keywords = keywords;
	}

	public String getExampleReplace() {
		return exampleReplace;
	}

	public void setExampleReplace(String exampleReplace) {
		this.exampleReplace = exampleReplace;
	}
	
	public String getIndustry() {
		return industry;
	}

	public void setIndustry(String industry) {
		this.industry = industry;
	}

	public void createKeywords() {
		WeixinTempDocFactory.parseKeywords(this);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

}
