package com.mini.framework.third.weixin.util;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

import com.mini.framework.core.exception.HandleEnDeCodeException;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.log.Event5WBuilder;
import com.mini.framework.util.string.StringUtil;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;

//https://developers.weixin.qq.com/miniprogram/dev/framework/open-ability/signature.html

/**
 * 微信aes加解密工具类
 * @author jayheo
 *
 */
public class WeixinAesCryptUtil {

	private static Logger logger = LogManager.getLogger(WeixinAesCryptUtil.class);
	
	private static boolean addProvider = false;

	private static void sureAddProvider() {
		if (!addProvider) {
			synchronized (WeixinAesCryptUtil.class) {
				if (!addProvider) {
					Security.addProvider(new BouncyCastleProvider());
					addProvider = true;
				}
			}
		}

	}
	
	
	//Given final block not properly padded 如果用户信息的json是code不是同时取的就经常出现这个问题。
	//已测试出来 ，如果 encryptedData 比sessionkey对应的code先获取就会爆出这个错
	
	public static String decryptData(String encryptedData, String iv, String sessionKey){
		try {
			String result = decryptDataThrows(encryptedData, iv, sessionKey);
			Event5WBuilder event = Event5WBuilder.event(1, "decryptData")
					.what("解密微信数据encryptedData:%s,iv:%s,sessionKey:%s",encryptedData,iv,sessionKey)
					.result("result:%s", result);
					logger.debug(event);
			return result;
		}catch(BadPaddingException e){
			//已测试出来 ，如果 encryptedData 比sessionkey对应的code先获取就会爆出这个错
			throw new HandleEnDeCodeException(e, "解密码微信密文时出错,如果 encryptedData 比sessionkey对应的code先获取就会爆出这个错");
		} catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException
				| InvalidParameterSpecException | InvalidAlgorithmParameterException | IllegalBlockSizeException
				 | NoSuchProviderException e) {
		Event5WBuilder event = Event5WBuilder.event(2, "decryptDataError")
		.what("解密微信数据的时候出错encryptedData:%s,iv:%s,sessionKey:%s",encryptedData,iv,sessionKey)
		.why("异常:%s", e.getMessage())
		.how("具体看错误栈");
		logger.error(event);
			throw new HandleEnDeCodeException(e, "解密码微信密文时出错");
		}catch(Throwable e){
			throw new HandleEnDeCodeException(e, "解密码微信密文时出错未知异常");
		}
	}
	
	private static String decryptDataThrows(String encryptedData, String iv, String sessionKey)
			throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidParameterSpecException,
			InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException,
			NoSuchProviderException {
		AssertUtil.assertMethodRequire(encryptedData,"encryptedData");
		AssertUtil.assertMethodRequire(sessionKey,"sessionKey");
		AssertUtil.assertMethodRequire(iv,"iv");
		// 被加密的数据
		byte[] dataByte = Base64.decode(encryptedData);
		AssertUtil.validateParams(dataByte!=null,"encryptedData base64格式不正确");
		// 加密秘钥
		byte[] keyByte = Base64.decode(sessionKey);
		AssertUtil.validateParams(keyByte!=null,"sessionKey base64格式不正确");
		// 偏移量
		byte[] ivByte = Base64.decode(iv);
		AssertUtil.validateParams(ivByte!=null,"iv base64格式不正确");
		// 如果密钥不足16位，那么就补足. 这个if 中的内容很重要
		keyByte = fillByte(keyByte, 16);
		// 初始化
		sureAddProvider();
		Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
		SecretKeySpec spec = new SecretKeySpec(keyByte, "AES");
		AlgorithmParameters parameters = AlgorithmParameters.getInstance("AES");
		parameters.init(new IvParameterSpec(ivByte));
		cipher.init(Cipher.DECRYPT_MODE, spec, parameters);// 初始化
		byte[] resultByte = cipher.doFinal(dataByte);
		String result = StringUtil.toUtf8String(resultByte);
		return result;
	}
	
	/**
	 * 填充字节
	 * TODO 这个方法还没有测试，如果有问题要测试
	 * @param sourseByte
	 * @param length
	 * @return
	 */
	private static byte[] fillByte(byte[] sourseByte,int length) {
		AssertUtil.assertMethodRequire(sourseByte, "sourseByte");
		if(sourseByte.length % length != 0){
			int groups = sourseByte.length / length + (sourseByte.length % length != 0 ? 1 : 0);
			byte[] result = new byte[groups * length];
			Arrays.fill(result, (byte) 0);
			System.arraycopy(sourseByte, 0, result, 0, sourseByte.length);
			return result;
		}
		return sourseByte;
	}
	
	
}
