package com.mini.framework.third.weixin.wxpay.v3.model.weixin;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.util.asserts.AssertUtil;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * @author jayheo
 */
public class TradeOrderHistoryRecordItem {


    /**
     * <pre>
     交易时间
     公众账号ID
     商户号
     特约商户号
     设备号
     微信订单号
     商户订单号
     用户标识
     交易类型
     交易状态
     付款银行
     货币种类
     应结订单金额
     代金券金额
     商品名称
     商户数据包
     手续费
     费率
     订单金额
     费率备注
     * </pre>
     */
    private String originContent;


    /**
     * 交易时间
     * 2021-09-18 15:20:06
     */
    private Date orderDate;


    /**
     * 公众账号ID
     * wxd6c0b072832b840f
     */
    private String appid;


    /**
     * 商户号
     * 1555371381
     */
    private String marketKey;


    /**
     * 微信订单号
     * 4200001129202109186346723090
     */
    private String weixinOrderNumber;

    /**
     * 商户订单号
     * CWS2021091855201952658
     */
    private String siteOrderNumber;


    /**
     * 用户标识
     * otl805QVEzEHZggUqcxpr3o2nWQY
     */
    private String openid;


    /**
     * 交易类型
     * JSAPI
     */
    private String tradeChannelType;


    /**
     * 交易状态
     * SUCCESS
     */
    private String weixinStatus;


    /**
     * 应结订单金额
     * 0.01
     */
    private Integer orderMoney;


    /**
     * 商品描述
     * 产品订单-17640187
     */
    private String description;


    public static TradeOrderHistoryRecordItem fromOriginLine(String originLine){
        TradeOrderHistoryRecordItem instance = new TradeOrderHistoryRecordItem();
        instance.originContent = originLine;
        instance.fillFromThisOriginContent();
        return instance;
    }


    public static boolean isItemOriginLine(String originLine){
        List<String> items = TradeOrderHistoryPackage.splitItemFromOriginLine(originLine);
        //`2021-09-18 18:28:11,`wx4c460d04aeb7982c,`1555371381,`0,`,`4200001212202109187293656122,`CWS2021091866487028628,`otPbOvoB7rvfz3Cokphv_VBXOR24,`MWEB,`SUCCESS,`OTHERS,`CNY,`0.01,`0.00,`产品订单-17640310,`,`0.00000,`0.54%,`0.01,`
        //第20项是备注，有可能有，有可能没有。所以是19或者20项
        return items.size()>=19 && items.size()<=20;

    }


    public TradeOrderHistoryRecordItem fillFromThisOriginContent(){
        AssertUtil.assertNotFatalBug(originContent!=null,"originContent不能为空");
        List<String> items = TradeOrderHistoryPackage.splitItemFromOriginLine(this.originContent);
        isItemOriginLine(this.originContent);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-DD HH:mm:ss");
        try {
            this.orderDate = format.parse(items.get(0));
        } catch (ParseException e) {
            throw new ServerException(e,"TODO 日期解析错误");
        }
        this.appid = items.get(1);
        this.marketKey = items.get(2);
        this.weixinOrderNumber = items.get(5);
        this.siteOrderNumber = items.get(6);
        this.openid = items.get(7);
        this.tradeChannelType = items.get(8);
        this.weixinStatus = items.get(9);
        this.orderMoney = TradeOrderHistoryPackage.moneyFenFromYuan(items.get(12));
        this.description = items.get(14);

        //`2021-09-18 18:28:11,`wx4c460d04aeb7982c,`1555371381,`0,`,`4200001212202109187293656122,`CWS2021091866487028628,`otPbOvoB7rvfz3Cokphv_VBXOR24,`MWEB,`SUCCESS,`OTHERS,`CNY,`0.01,`0.00,`产品订单-17640310,`,`0.00000,`0.54%,`0.01,`
        return this;
    }



    public String getOriginContent() {
        return originContent;
    }

    public void setOriginContent(String originContent) {
        this.originContent = originContent;
    }

    public Date getOrderDate() {
        return orderDate;
    }

    public void setOrderDate(Date orderDate) {
        this.orderDate = orderDate;
    }

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getMarketKey() {
        return marketKey;
    }

    public void setMarketKey(String marketKey) {
        this.marketKey = marketKey;
    }

    public String getWeixinOrderNumber() {
        return weixinOrderNumber;
    }

    public void setWeixinOrderNumber(String weixinOrderNumber) {
        this.weixinOrderNumber = weixinOrderNumber;
    }

    public String getSiteOrderNumber() {
        return siteOrderNumber;
    }

    public void setSiteOrderNumber(String siteOrderNumber) {
        this.siteOrderNumber = siteOrderNumber;
    }

    public String getOpenid() {
        return openid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public String getTradeChannelType() {
        return tradeChannelType;
    }

    public void setTradeChannelType(String tradeChannelType) {
        this.tradeChannelType = tradeChannelType;
    }

    public String getWeixinStatus() {
        return weixinStatus;
    }

    public void setWeixinStatus(String weixinStatus) {
        this.weixinStatus = weixinStatus;
    }

    public Integer getOrderMoney() {
        return orderMoney;
    }

    public void setOrderMoney(Integer orderMoney) {
        this.orderMoney = orderMoney;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }



    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
