package com.mini.framework.third.weixin.wxpay.v3.model.weixin;

import com.google.gson.annotations.SerializedName;

/**
 * 微信支付 查询支付订单的的响应
 * @author jayheo
 */
public class WxpayQueryPayOrderResponse extends WxpayResponse {

    //https://pay.weixin.qq.com/wiki/doc/apiv3/apis/chapter3_1_2.shtml

    /**
     * 微信应用id<BR>
     * string[1,32]<br>
     * 必填：是<br>
     * 由微信生成的应用ID，全局唯一。请求基础下单接口时请注意APPID的应用属性，例如公众号场景下，需使用应用属性为公众号的APPID<BR>
     * 例如:wxd678efh567hg6787
     */
    @SerializedName("appid")
    private String appid;




    /**
     * 微信支付商户号<BR>
     * string[1,32]<BR>
     * 必填：是<br>
     * 直连商户的商户号，由微信支付生成并下发。<BR>
     * 例如:1230000109<BR>
     */
    @SerializedName("mchid")
    private String marketKey;




    /**
     * 商户订单号<BR>
     * string[6,32]<BR>
     * 必填：是<br>
     * 商户系统内部订单号，只能是数字、大小写字母_-*且在同一个商户号下唯一<BR>
     * 例如:1217752501201407033233368018<BR>
     */
    @SerializedName("out_trade_no")
    private String siteOrderNumber;


    /**
     * 微信支付订单号<BR>
     * 微信支付系统生成的订单号。<BR>
     * 例如:1217752501201407033233368018
     */
    @SerializedName("transaction_id")
    private String wxpayOrderNumber;


    /**
     * 交易状态
     */
    //TODO 需要映射成枚举
    @SerializedName("trade_state")
    private String tradeStatus;

    /**
     * 交易状态描述
     */
    @SerializedName("trade_state_desc")
    private String tradeStatusDesc;

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getMarketKey() {
        return marketKey;
    }

    public void setMarketKey(String marketKey) {
        this.marketKey = marketKey;
    }

    public String getSiteOrderNumber() {
        return siteOrderNumber;
    }

    public void setSiteOrderNumber(String siteOrderNumber) {
        this.siteOrderNumber = siteOrderNumber;
    }

    public String getWxpayOrderNumber() {
        return wxpayOrderNumber;
    }

    public void setWxpayOrderNumber(String wxpayOrderNumber) {
        this.wxpayOrderNumber = wxpayOrderNumber;
    }

    public String getTradeStatus() {
        return tradeStatus;
    }

    public void setTradeStatus(String tradeStatus) {
        this.tradeStatus = tradeStatus;
    }

    public String getTradeStatusDesc() {
        return tradeStatusDesc;
    }

    public void setTradeStatusDesc(String tradeStatusDesc) {
        this.tradeStatusDesc = tradeStatusDesc;
    }
}
