package com.mini.framework.third.weixin.wxpay.v3.model.weixin;

import com.mini.framework.third.weixin.wxpay.v3.client.WxpayResponseMessageFounder;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.util.Optional;

/**
 * @author jayheo
 */
public abstract class WxpayResponse implements WxpayResponseMessageFounder {

    /**
     * TODO 这是通过Gson转过来的，如果把原报文保存呢？
     * 原始的报文
     */
    private String originMessage;


    private String uniqueMessageId;

    @Override
    public void foundWxpayResponseBody(Optional<String> bodyOptional) {
        bodyOptional.ifPresent(this::setOriginMessage);
    }


    @Override
    public void foundWxpayResponseUniqueMessageId(Optional<String> uniqueMessageIdOptional) {
        uniqueMessageIdOptional.ifPresent(this::setUniqueMessageId);
    }

    public String getOriginMessage() {
        return originMessage;
    }

    public void setOriginMessage(String originMessage) {
        this.originMessage = originMessage;
    }

    public String getUniqueMessageId() {
        return uniqueMessageId;
    }

    public void setUniqueMessageId(String uniqueMessageId) {
        this.uniqueMessageId = uniqueMessageId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
