/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.cl253.model;

import com.mini.framework.core.exception.BadReqException;
import com.mini.framework.third.cl253.comm.SendSmsCommRequest;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.string.RegexUtil;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class SendSmsRequest {
    private String siteSign;
    private String content;
    private String[] phones;

    public String getSiteSign() {
        return this.siteSign;
    }

    public void setSiteSign(String siteSign) {
        this.siteSign = siteSign;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String[] getPhones() {
        return this.phones;
    }

    public void setPhones(String[] phones) {
        this.phones = phones;
    }

    public SendSmsRequest() {
    }

    public static SendSmsRequest fromCommand(String command) {
        return SendSmsRequest.fromCommand(command, "@@");
    }

    public static SendSmsRequest fromCommand(String command, String split) {
        AssertUtil.assertMethodRequire((Object)command, (String)"command");
        AssertUtil.assertMethodRequire((Object)split, (String)"split");
        String regex = String.format("([^%s]*)%s([^%s]*)%s([0-9,]*)", split, split, split, split);
        String[] items = RegexUtil.getMatch((String)regex, (String)command, (int[])new int[]{1, 2, 3});
        if (items == null) {
            throw new BadReqException("\u77ed\u4fe1\u547d\u4ee4\u4e0d\u7b26\u5408\u89c4\u8303command:[%s]", new Object[]{command});
        }
        return new SendSmsRequest(items[0], items[1], items[2].split(","));
    }

    public SendSmsRequest(String siteSign, String content, String ... phones) {
        this.siteSign = siteSign;
        this.content = content;
        this.phones = phones;
    }

    public SendSmsCommRequest createCommReq() {
        String message = String.format("\u3010%s\u3011%s", this.siteSign, this.content);
        SendSmsCommRequest commReq = new SendSmsCommRequest();
        commReq.setMessage(message);
        commReq.setPhones(this.phones);
        return commReq;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

