/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.resourse.article.block;

import com.mini.framework.core.exception.HandleIOException;
import com.mini.framework.third.resourse.article.block.ResourseAnalysis;
import com.mini.framework.third.resourse.article.block.model.ArticleRawContent;
import com.mini.framework.util.asserts.AssertUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class WeixinPublicArticleAnalysis
implements ResourseAnalysis {
    @Override
    public String analysisKey() {
        return "weixinPublicDocument";
    }

    @Override
    public boolean urlResourseMatch(String url) {
        AssertUtil.assertMethodRequire((Object)url, (String)"url");
        String regex = "https://mp\\.weixin\\.qq\\.com/s/.*";
        return url.matches(regex);
    }

    @Override
    public ArticleRawContent analysis(String url) {
        Document document;
        ArticleRawContent articleRawContent = new ArticleRawContent();
        String docId = Arrays.stream(url.split("/s/")).filter(v -> !v.startsWith("http")).findFirst().orElse("");
        Connection connection = Jsoup.connect((String)url).userAgent("Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.143 Safari/537.36");
        try {
            document = connection.timeout(100000).get();
        }
        catch (IOException e) {
            throw new HandleIOException((Throwable)e, "\u6587\u7ae0\u8bf7\u6c42\u8d85\u65f6:[%s]", new Object[]{url});
        }
        String title = Optional.ofNullable(document.select(".rich_media_title")).map(Elements::first).map(Element::text).orElse("\u6807\u9898\u672a\u91c7\u96c6\u5230");
        String account = Optional.ofNullable(document.select("#js_name")).map(Elements::first).map(Element::text).orElse("\u5904\u7406\u516c\u4f17\u53f7\u540d\u79f0\u672a\u91c7\u96c6\u5230");
        Elements select = document.select("#js_content").select("p,figure,pre,h4,h5,table");
        select.forEach(element -> {
            String text;
            Elements imgs = element.select("img");
            if (CollectionUtils.isNotEmpty((Collection)imgs)) {
                String src = imgs.attr("data-src");
                String type = imgs.attr("data-type");
                if (StringUtils.isNotBlank((CharSequence)src) && StringUtils.isNotBlank((CharSequence)type)) {
                    articleRawContent.createContent("img", src, type);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(text = element.text()))) {
                articleRawContent.createContent(element.tagName(), text);
            }
            articleRawContent.setId(docId);
            articleRawContent.setAccount(account);
            articleRawContent.setTitle(title);
        });
        return articleRawContent;
    }
}

