/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.console.server;

import com.mini.framework.core.exception.BadReqException;
import com.mini.framework.core.exception.standard.CustomException;
import com.mini.framework.core.status.Status;
import com.mini.framework.core.status.StatusCode;
import com.mini.framework.third.weixin.console.ConsoleProxyCommandHelper;
import com.mini.framework.third.weixin.console.model.WeixinCurlCommand;
import com.mini.framework.third.weixin.console.model.WeixinCurlCommandSectionable;
import com.mini.framework.third.weixin.console.server.handler.TemplateSyncHandler;
import com.mini.framework.third.weixin.console.server.model.template.Document;
import com.mini.framework.third.weixin.console.server.model.template.DocumentListResponse;
import com.mini.framework.third.weixin.console.server.model.template.SyncItemResultType;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.log.Event5WBuilder;
import com.mini.framework.util.log.MiniLogLevel;
import com.mini.framework.util.string.RegexUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WeixinServerTemplateHelper {
    private static Logger logger = LogManager.getLogger(WeixinServerTemplateHelper.class);

    public static void syncTemplateDocument(String consoleCommand, int beginSyncOffset, int syncLimit, TemplateSyncHandler handler) {
        WeixinServerTemplateHelper.syncTemplateDocument(consoleCommand, beginSyncOffset, syncLimit, handler, msg -> new BadReqException(Status.BadReq.illParam, "\u540c\u6b65\u5fae\u4fe1\u6a21\u677f\u6587\u6863\u65f6\u51fa\u9519:%s", new Object[]{msg}));
    }

    public static <E extends CustomException> void syncTemplateDocument(String consoleCommand, int beginSyncOffset, int syncLimit, TemplateSyncHandler handler, Function<String, E> exceptionSupplier) throws E {
        int limitIndex = beginSyncOffset + syncLimit;
        int sectionSize = 100;
        WeixinCurlCommandSectionable command = new WeixinCurlCommandSectionable(ConsoleProxyCommandHelper.parseBachCurl(consoleCommand)).setSection(beginSyncOffset, Math.min(syncLimit, sectionSize), sectionSize);
        String apiUrl = "https://mp.weixin.qq.com/advanced/tmplmsg";
        AssertUtil.assertNoBadReq((boolean)command.getUrl().startsWith(apiUrl), (StatusCode)Status.BadReq.illParam, (String)"\u4ece\u547d\u4ee4\u4e2d\u5f97\u5230url:[%s]\u5fc5\u987b\u4ee5:[%s]\u4e3a\u8d77\u59cb\u503c", (Object[])new Object[]{command.getUrl(), apiUrl});
        Integer count = null;
        boolean firstReq = true;
        do {
            String responseBody = ConsoleProxyCommandHelper.exeUseUrlAndCookie(command.getUrl(), command.getCookie());
            logger.log(MiniLogLevel.getKeyBizLog(), (Object)Event5WBuilder.event((int)2, (Object)"syncWeixinServerTemplateDocument").what("\u5f97\u5230\u5fae\u4fe1\u7aef\u7684\u54cd\u5e94:%s", new Object[]{responseBody}));
            DocumentListResponse response = DocumentListResponse.fromJson(responseBody).loadData(exceptionSupplier);
            count = response.getDocumentCount();
            AssertUtil.simpleAssertByStatus((count != null ? 1 : 0) != 0, (StatusCode)Status.Third.wxTemplate, (String)"\u540c\u6b65\u6a21\u677f\u7684\u65f6\u8bf7\u6c42\u4e2d\u5206\u9875\u54cd\u5e94\u6ca1\u6709\u53d1\u73b0\u5fc5\u8981\u7684count", (Object[])new Object[0]);
            if (firstReq && !handler.readyIfExecute(response.getDocumentCount())) {
                return;
            }
            List<Document> reomteDocumentSimples = response.getDocuments();
            Set<String> keys = reomteDocumentSimples.stream().map(Document::getKey).filter(Objects::nonNull).collect(Collectors.toSet());
            List<Document> localDocuments = handler.queryLocalDocuments(keys);
            for (Document remoteDocumentSimple : reomteDocumentSimples) {
                SyncItemResultType oneResult = SyncItemResultType.undo;
                String key = remoteDocumentSimple.getKey();
                handler.beforeOneHandle(key);
                Optional<Document> localDocumentOptional = localDocuments.stream().filter(d -> d.matchKey(key)).findFirst();
                boolean todoNewRecord = !localDocumentOptional.isPresent();
                boolean todoUpdate = localDocumentOptional.filter(localDocument -> localDocument.ifRequireResyncFromSimple(remoteDocumentSimple)).isPresent();
                if (todoNewRecord || todoUpdate) {
                    Event5WBuilder event = Event5WBuilder.event((int)2, (Object)"syncTemplateDocumentDiscoverChange").who("\u53d1\u73b0\u9700\u8981\u540c\u6b65\u7684\u6587\u6863:[%s]", new Object[]{key}).what("todoNewRecord:[%s],todoUpdate:[%s]", new Object[]{todoNewRecord, todoUpdate}).how("\u68c0\u67e5\u8fdc\u7a0b\u548c\u672c\u5730\u7684\u6587\u4ef6 remoteSameKey:[%s],localSameKey:[%s]", new Object[]{remoteDocumentSimple.simpleKeyForUpdate(), localDocumentOptional.map(Document::simpleKeyForUpdate).orElse("\u6ca1\u6709\u672c\u5730\u5185\u5bb9")});
                    logger.info((Object)event);
                    Optional<Document> fullRemoteDocmentOptional = WeixinServerTemplateHelper.queryTemplateDocument(key, command);
                    if (fullRemoteDocmentOptional.isPresent()) {
                        Document fullRemoteDocment = fullRemoteDocmentOptional.get();
                        if (todoUpdate) {
                            handler.setDocument(key, fullRemoteDocment);
                            oneResult = SyncItemResultType.update;
                        }
                        if (todoNewRecord) {
                            handler.addDocument(fullRemoteDocment);
                            oneResult = SyncItemResultType.newRecord;
                        }
                    } else {
                        oneResult = SyncItemResultType.reqError;
                    }
                }
                handler.afterOneHandle(key, oneResult);
            }
            firstReq = false;
        } while (command.nextSection(Math.min(limitIndex, count)));
        handler.endHandle();
    }

    public static Optional<Document> queryTemplateDocument(String key, WeixinCurlCommand command) {
        String urlTemp = "https://mp.weixin.qq.com/advanced/tmplmsg?action=tmpl_preview&t=tmplmsg/preview&id=%s&token=%s&lang=zh_CN";
        String token = command.getTokenParam();
        String url = String.format(urlTemp, key, token);
        String responseBody = ConsoleProxyCommandHelper.exeUseUrlAndCookie(url, command.getCookie());
        List lines = Stream.of(responseBody.split("\r\n")).collect(Collectors.toList());
        Collections.reverse(lines);
        String foundJson = null;
        for (String line : lines) {
            String matchJson = RegexUtil.getMatch((String)"tmplmsg:(.*)", (String)line, (int)1);
            if (matchJson == null) continue;
            foundJson = matchJson;
            break;
        }
        return Optional.ofNullable(foundJson).map(Document::fromJson);
    }
}

