/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.console.server.model.template;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Document {
    @SerializedName(value="id")
    private String key;
    @SerializedName(value="title")
    private String title;
    @SerializedName(value="class1")
    private String firstIndustryName;
    @SerializedName(value="class2")
    private String secondIndustryName;
    @SerializedName(value="person_used")
    private Integer useCount;
    @SerializedName(value="invalid")
    private Integer invalid;
    @SerializedName(value="reason")
    private String statusReason;
    @SerializedName(value="modify_time")
    private String updateDate;
    @SerializedName(value="content")
    private String template;
    @SerializedName(value="example")
    private String example;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getFirstIndustryName() {
        return this.firstIndustryName;
    }

    public void setFirstIndustryName(String firstIndustryName) {
        this.firstIndustryName = firstIndustryName;
    }

    public String getSecondIndustryName() {
        return this.secondIndustryName;
    }

    public void setSecondIndustryName(String secondIndustryName) {
        this.secondIndustryName = secondIndustryName;
    }

    public Integer getUseCount() {
        return this.useCount;
    }

    public void setUseCount(Integer useCount) {
        this.useCount = useCount;
    }

    public Integer getInvalid() {
        return this.invalid;
    }

    public void setInvalid(Integer invalid) {
        this.invalid = invalid;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public String getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(String updateDate) {
        this.updateDate = updateDate;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getExample() {
        return this.example;
    }

    public void setExample(String example) {
        this.example = example;
    }

    public boolean beforeThan(Document other) {
        if (other.updateDate != null) {
            return this.updateDate == null || other.updateDate.compareTo(this.updateDate) > 0;
        }
        return false;
    }

    public boolean matchKey(String key) {
        return Objects.equals(this.key, key);
    }

    public static Document fromJson(String json) {
        return (Document)new Gson().fromJson(json, Document.class);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean theSameStatusWithSimple(Document documentSimple) {
        return this.simpleKeyForUpdate().equals(documentSimple.simpleKeyForUpdate());
    }

    public boolean ifRequireResyncFromSimple(Document documentSimple) {
        return this.beforeThan(documentSimple) || !this.theSameStatusWithSimple(documentSimple);
    }

    public String simpleKeyForUpdate() {
        String key = Stream.of(this.key, this.title, this.firstIndustryName, this.secondIndustryName, this.useStatus()).map(String::valueOf).collect(Collectors.joining("-"));
        return key;
    }

    public boolean useStatus() {
        return this.invalid == null || this.invalid != 1;
    }
}

