/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.console.server.model.template;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.mini.framework.core.exception.standard.CustomException;
import com.mini.framework.third.weixin.console.server.model.template.CurrentMatchIndustry;
import com.mini.framework.third.weixin.console.server.model.template.Document;
import com.mini.framework.third.weixin.console.server.model.template.FirstIndustry;
import com.mini.framework.third.weixin.console.server.model.template.ResponseStatusBean;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class DocumentListResponse {
    @SerializedName(value="base_resp")
    private ResponseStatusBean status;
    @SerializedName(value="data")
    private String dataNodeString;
    private List<FirstIndustry> industrys;
    private List<Document> documents;
    private Integer documentCount;
    private DataNode dataNode;
    @SerializedName(value="tmpl_msg_attr_info")
    private CurrentMatchIndustry currentMatchIndustry;

    public <E extends CustomException> void validateStatus(Function<String, E> exceptionSupplier) throws E {
        if (this.status == null) {
            throw (CustomException)exceptionSupplier.apply(String.format("\u7ed3\u679c\u9519\u8bef\u6ca1\u6709status\u8282\u70b9key:[%s]", "base_resp"));
        }
        if (!this.status.success()) {
            throw (CustomException)exceptionSupplier.apply(String.format("\u8bf7\u6c42\u9519\u8befmsg:[%s],code:[%s]", this.status.getMsg(), this.status.getCode()));
        }
    }

    public <E extends CustomException> DocumentListResponse loadData(Function<String, E> exceptionSupplier) throws E {
        this.validateStatus(exceptionSupplier);
        this.dataNode = (DataNode)new Gson().fromJson(this.dataNodeString, DataNode.class);
        if (this.dataNode != null) {
            this.documents = this.dataNode.templateNode.documents;
            this.industrys = this.dataNode.industryNode.industrys;
            this.documentCount = this.dataNode.templateNode.documentCount;
        }
        return this;
    }

    public ResponseStatusBean getStatus() {
        return this.status;
    }

    public void setStatus(ResponseStatusBean status) {
        this.status = status;
    }

    public String getDataNodeString() {
        return this.dataNodeString;
    }

    public void setDataNodeString(String dataNodeString) {
        this.dataNodeString = dataNodeString;
    }

    public List<FirstIndustry> getIndustrys() {
        return this.industrys;
    }

    public void setIndustrys(List<FirstIndustry> industrys) {
        this.industrys = industrys;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    public Integer getDocumentCount() {
        return this.documentCount;
    }

    public void setDocumentCount(Integer documentCount) {
        this.documentCount = documentCount;
    }

    public DataNode getDataNode() {
        return this.dataNode;
    }

    public void setDataNode(DataNode dataNode) {
        this.dataNode = dataNode;
    }

    public CurrentMatchIndustry getCurrentMatchIndustry() {
        return this.currentMatchIndustry;
    }

    public void setCurrentMatchIndustry(CurrentMatchIndustry currentMatchIndustry) {
        this.currentMatchIndustry = currentMatchIndustry;
    }

    public static DocumentListResponse fromJson(String json) {
        return (DocumentListResponse)new Gson().fromJson(json, DocumentListResponse.class);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static class DataNode {
        @SerializedName(value="class_info")
        private IndustryNode industryNode;
        @SerializedName(value="store_tmpl_info")
        private TemplateNode templateNode;

        public IndustryNode getIndustryNode() {
            return this.industryNode;
        }

        public void setIndustryNode(IndustryNode industryNode) {
            this.industryNode = industryNode;
        }

        public TemplateNode getTemplateNode() {
            return this.templateNode;
        }

        public void setTemplateNode(TemplateNode templateNode) {
            this.templateNode = templateNode;
        }

        public static class TemplateNode {
            @SerializedName(value="store_tmpl")
            private List<Document> documents;
            @SerializedName(value="total_count")
            private Integer documentCount;

            public Integer getDocumentCount() {
                return this.documentCount;
            }

            public void setDocumentCount(Integer documentCount) {
                this.documentCount = documentCount;
            }

            public List<Document> getDocuments() {
                return this.documents;
            }

            public void setDocuments(List<Document> documents) {
                this.documents = documents;
            }
        }

        public static class IndustryNode {
            @SerializedName(value="sub_class")
            private List<FirstIndustry> industrys;

            public List<FirstIndustry> getIndustrys() {
                return this.industrys;
            }

            public void setIndustrys(List<FirstIndustry> industrys) {
                this.industrys = industrys;
            }
        }
    }
}

