/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.pay;

import com.mini.framework.third.weixin.pay.client.MappRefundResponse;
import com.mini.framework.third.weixin.pay.client.MappSiteTransferInfoResponse;
import com.mini.framework.third.weixin.pay.client.MappTransferResponse;
import com.mini.framework.third.weixin.pay.client.PayApiClient;
import com.mini.framework.third.weixin.pay.client.SiteQueryTransferInfoPreRequest;
import com.mini.framework.third.weixin.pay.client.SiteQueryTransferInfoRequest;
import com.mini.framework.third.weixin.pay.client.UserMappRefundPreRequest;
import com.mini.framework.third.weixin.pay.client.UserMappTransferPreRequest;
import com.mini.framework.third.weixin.pay.model.SiteTransferInfoResponse;
import com.mini.framework.third.weixin.pay.model.UserMappRefundRequest;
import com.mini.framework.third.weixin.pay.model.UserMappRefundResponse;
import com.mini.framework.third.weixin.pay.model.UserMappTransferRequest;
import com.mini.framework.third.weixin.pay.model.UserMappTransferResponse;
import com.mini.framework.third.weixin.pay.model.WeixinCompanyPayConfig;
import com.mini.framework.util.paas.MultiSiteConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WeixinCompanyPayHelper<S> {
    Logger logger = LogManager.getLogger(WeixinCompanyPayHelper.class);
    private MultiSiteConfig<S, WeixinCompanyPayConfig> wxPay4PayOutConfig;

    public WeixinCompanyPayHelper(MultiSiteConfig<S, WeixinCompanyPayConfig> wxPay4PayOutConfig) {
        this.wxPay4PayOutConfig = wxPay4PayOutConfig;
    }

    public UserMappRefundResponse wechatPayRefund(UserMappRefundRequest request) {
        WeixinCompanyPayConfig config = (WeixinCompanyPayConfig)this.wxPay4PayOutConfig.currBean();
        UserMappRefundPreRequest preRequest = new UserMappRefundPreRequest(request);
        preRequest.fillConfig(config);
        preRequest.setNotifyUrl(config.getNotifyUrl());
        preRequest.sign(config.getMchKey());
        MappRefundResponse mappRefundResponse = PayApiClient.mappRefund(preRequest);
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        UserMappRefundResponse userMappRefundResponse = new UserMappRefundResponse();
        userMappRefundResponse.setTimeStamp(timeStamp);
        userMappRefundResponse.setAppId(mappRefundResponse.getAppid());
        userMappRefundResponse.setOutTradeNo(request.getOrderId());
        userMappRefundResponse.sign(config.getMchKey());
        return userMappRefundResponse;
    }

    public SiteTransferInfoResponse queryTransferInfo(SiteQueryTransferInfoRequest request) {
        WeixinCompanyPayConfig config = (WeixinCompanyPayConfig)this.wxPay4PayOutConfig.currBean();
        SiteQueryTransferInfoPreRequest preRequest = new SiteQueryTransferInfoPreRequest(request);
        preRequest.setSignType(null);
        preRequest.fillConfig(config);
        preRequest.sign(config.getMchKey());
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        MappSiteTransferInfoResponse response = PayApiClient.mappTransferInfo(preRequest, config.getSslContext());
        SiteTransferInfoResponse siteTransferInfoResponse = new SiteTransferInfoResponse();
        siteTransferInfoResponse.setAppId(response.getAppid());
        siteTransferInfoResponse.setPartnerTradeNo(response.getPartnerTradeNo());
        siteTransferInfoResponse.setTimeStamp(timeStamp);
        siteTransferInfoResponse.setStatus(response.getStatus());
        siteTransferInfoResponse.setReason(response.getReason());
        siteTransferInfoResponse.setPaymentTime(response.getPaymentTime());
        return siteTransferInfoResponse;
    }

    public UserMappTransferResponse wechatPayTransfer(UserMappTransferRequest request) {
        WeixinCompanyPayConfig config = (WeixinCompanyPayConfig)this.wxPay4PayOutConfig.currBean();
        UserMappTransferPreRequest preRequest = new UserMappTransferPreRequest(request);
        preRequest.setSignType(null);
        preRequest.fillConfig4Mch(config);
        preRequest.setSpbillCreateIp(request.getSpbillCreateIp());
        preRequest.sign(config.getMchKey());
        MappTransferResponse response = PayApiClient.wechatPayTransfer(preRequest, config.getSslContext());
        UserMappTransferResponse userMappTransferResponse = new UserMappTransferResponse();
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        userMappTransferResponse.setTimeStamp(timeStamp);
        userMappTransferResponse.setSiteOrderNo(response.getPartnerTradeNo());
        userMappTransferResponse.setPaymentNo(response.getPaymentNo());
        userMappTransferResponse.sign(config.getMchKey());
        return userMappTransferResponse;
    }
}

