/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.pay.model;

import com.mini.framework.core.status.Status;
import com.mini.framework.core.status.StatusCode;
import com.mini.framework.util.asserts.AssertUtil;
import java.util.stream.Stream;

public enum SitePayStatusType {
    withdrawConfigErr(new String[]{"NO_AUTH", "PAY_CHANNEL_NOT_ALLOWED", "AMOUNT_LIMIT", "SIGN_ERROR", "MONEY_LIMIT", "CA_ERROR", "RECV_ACCOUNT_NOT_ALLOWED"}, Status.Third.siteWithdrawConfigErr),
    siteBalanceNotEnough(new String[]{"NOTENOUGH"}, Status.Third.siteBalanceNotEnough),
    siteWithNoNotFound(new String[]{"NOT_FOUND"}, Status.Third.wxPayNoNotFound),
    sitePayErr(new String[]{"SEND_FAILED"}, Status.Third.wxPayErr),
    reqErr(new String[]{"PARAM_ERROR", "OPENID_ERROR", "XML_ERROR", "FATAL_ERROR", "FREQ_LIMIT", "PARAM_IS_NOT_UTF8", "V2_ACCOUNT_SIMPLE_BAN", "SENDNUM_LIMIT"}, Status.Third.wxPay),
    wxServerErr(new String[]{"SYSTEMERROR"}, Status.Third.wxPayServerErr);

    private String[] wxErrCodes;
    private StatusCode selfStatusCode;

    private SitePayStatusType(String[] wxErrCodes, StatusCode selfStatusCode) {
        this.wxErrCodes = wxErrCodes;
        this.selfStatusCode = selfStatusCode;
    }

    public static SitePayStatusType weixinPublicStatus(String statusResp) {
        AssertUtil.assertMethodRequire((Object)statusResp, (String)"statusResp");
        SitePayStatusType mapStatus = Stream.of(SitePayStatusType.values()).filter(status -> Stream.of(status.wxErrCodes).filter(map -> map.equals(statusResp)).count() == 1L).findFirst().orElse(null);
        return mapStatus;
    }

    public String[] getWxErrCodes() {
        return this.wxErrCodes;
    }

    public StatusCode getMap() {
        return this.selfStatusCode;
    }
}

