/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.pay.model;

import com.mini.framework.core.exception.BusyException;
import com.mini.framework.core.exception.HandleIOException;
import com.mini.framework.util.asserts.AssertUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.http.ssl.SSLContexts;
import sun.misc.BASE64Decoder;

public class WeixinCompanyPayConfig {
    private String notifyUrl;
    private String returnUrl;
    private String appId;
    private String mchId;
    private String mchKey;
    private String mchCert;
    private SSLContext sslContext;

    public SSLContext initSSLContext() {
        ByteArrayInputStream inputStream;
        AssertUtil.validateParams((this.mchCert != null ? 1 : 0) != 0, (String)"\u5546\u5bb6\u652f\u4ed8\u53f7\u8bc1\u4e66\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AssertUtil.validateParams((this.mchId != null ? 1 : 0) != 0, (String)"\u5546\u5bb6\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        try {
            byte[] bytes = new BASE64Decoder().decodeBuffer(this.mchCert);
            inputStream = new ByteArrayInputStream(bytes);
        }
        catch (IOException e) {
            throw new HandleIOException((Throwable)e, "\u8bfb\u53d6\u5fae\u4fe1\u5546\u6237\u8bc1\u4e66\u6587\u4ef6\u51fa\u9519", new Object[0]);
        }
        try {
            KeyStore keystore = KeyStore.getInstance("PKCS12");
            char[] partnerId2charArray = this.mchId.toCharArray();
            keystore.load(inputStream, partnerId2charArray);
            SSLContext sSLContext = this.sslContext = SSLContexts.custom().loadKeyMaterial(keystore, partnerId2charArray).build();
            return sSLContext;
        }
        catch (Exception e) {
            throw new BusyException("\u8bc1\u4e66\u6587\u4ef6\u6709\u95ee\u9898\uff0c\u8bf7\u6838\u5b9e\uff01", new Object[]{e});
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getMchId() {
        return this.mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getMchKey() {
        return this.mchKey;
    }

    public void setMchKey(String mchKey) {
        this.mchKey = mchKey;
    }

    public String getMchCert() {
        return this.mchCert;
    }

    public void setMchCert(String mchCert) {
        this.mchCert = mchCert;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

