/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.server.comm;

import com.mini.framework.third.weixin.server.comm.ReqSerializable;
import com.mini.framework.util.asserts.AssertUtil;

public class SceneQrcodeRequest
implements ReqSerializable {
    private String action;
    private Integer expire;
    private String qrKey;
    private String messageTemplate = "{'action_name': '%s', 'action_info': {'scene': {'scene_str': '%s'}}}";
    private String limitMessageTemplate = "{'expire_seconds': %s,'action_name': '%s', 'action_info': {'scene': {'scene_str': '%s'}}}";

    public static SceneQrcodeRequest create(String qrKey, boolean expire) {
        if (expire) {
            return new SceneQrcodeRequest(2592000, qrKey);
        }
        return new SceneQrcodeRequest(qrKey);
    }

    private SceneQrcodeRequest(int expire, String qrKey) {
        AssertUtil.assertSupport((expire <= 2592000 ? 1 : 0) != 0, (String)"\u4e34\u65f6\u4e8c\u7ef4\u7801\u6709\u6548\u671f\u4e0d\u80fd\u8d85\u8fc730\u5929", (Object[])new Object[0]);
        this.expire = expire;
        this.qrKey = qrKey;
        this.action = "QR_STR_SCENE";
    }

    private SceneQrcodeRequest(String qrKey) {
        this.qrKey = qrKey;
        this.action = "QR_LIMIT_STR_SCENE";
    }

    @Override
    public String serialize() {
        if (this.expire == null) {
            return String.format(this.messageTemplate, this.action, this.qrKey).replaceAll("'", "\"");
        }
        return String.format(this.limitMessageTemplate, this.expire, this.action, this.qrKey).replaceAll("'", "\"");
    }

    public String getAction() {
        return this.action;
    }

    public Integer getExpire() {
        return this.expire;
    }

    public String getQrKey() {
        return this.qrKey;
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public String getLimitMessageTemplate() {
        return this.limitMessageTemplate;
    }
}

